include(MessageFunctions)

function(EXCLUDE_SOURCES_FROM_LIST file_list exclude_list)
  set(_new_list ${${file_list}})
  foreach(_f ${${exclude_list}})
    if (NOT ";${_new_list};" MATCHES ";${_f};")
    	REPORT_PROBLEM_MESSAGE("Excluded file ${_f} not found in ${file_list}")
    else()
    	REPORT_VERBOSE_MESSAGE("Excluding ${_f}")
    	list(REMOVE_ITEM _new_list ${_f})
    endif()
	endforeach (_f)
  set(${file_list} ${_new_list} PARENT_SCOPE)
endfunction (EXCLUDE_SOURCES_FROM_LIST)
