﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdlib.h>

#include <nnt/nntest.h>
#include <nn/nn_Log.h>

const char* const HOST_MOUNT_PATH = "C:/";
const char* const TEST_PATH = "host:/ntd-test-libc-malloc-regression";
const char* const TEST_PATH_FILE1 = "host:/ntd-test-libc-malloc-regression/file1.txt";
const char* const TEST_PATH_FILE2 = "host:/ntd-test-libc-malloc-regression/file2.txt";

extern "C" size_t malloc_usable_size(void* p);

const int MAX_MALLOC_SIZE = 100000;

// Used by certain tests that require multiple mallocs
extern void* bytes[MAX_MALLOC_SIZE];

void FreeMallocMemory(int size);
void ReallocMallocMemory(int size);

struct Test
{
    void (*func)(void);
    const char* name;
    int memoryAllowed;
    int expectedSize;
    bool shouldBeFree;

    void* bytes;
};

extern Test tests[];

extern const int NUM_TESTS;

class LMRTestFixture : public ::testing::Test
{
protected:
    // setup and teardown for each test case
    virtual void SetUp() {}
    virtual void TearDown() {}
};
