﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/util/util_FormatString.h>

#include <nnt/gtest/detail/gtest-heap.h>
#include <nnt/gtest/detail/gtest-string.h>
#include <nnt/gtest/detail/gtest-sstream.h>

namespace nnt { namespace testing { namespace detail {

namespace {

const int BufferSize = 32;

} // namespace

StringStream& StringStream::operator<<(long long value) NN_NOEXCEPT
{
    char str[BufferSize];
    int length = nn::util::SNPrintf(str, BufferSize, "%lld", value);
    NN_SDK_ASSERT_RANGE(length, 0, BufferSize);
    NN_UNUSED(length);
    this->m_Buffer += str;
    return *this;
}

StringStream& StringStream::operator<<(unsigned long long value) NN_NOEXCEPT
{
    char str[BufferSize];
    int length = nn::util::SNPrintf(str, BufferSize, "%llu", value);
    NN_SDK_ASSERT_RANGE(length, 0, BufferSize);
    NN_UNUSED(length);
    this->m_Buffer += str;
    return *this;
}

StringStream& StringStream::operator<<(double value) NN_NOEXCEPT
{
    char str[BufferSize];
    int length = nn::util::SNPrintf(str, BufferSize, "%.17le", value);
    NN_SDK_ASSERT_RANGE(length, 0, BufferSize);
    NN_UNUSED(length);
    this->m_Buffer += str;
    return *this;
}

StringStream& StringStream::operator<<(float value) NN_NOEXCEPT
{
    char str[BufferSize];
    int length = nn::util::SNPrintf(str, BufferSize, "%.8e", value);
    NN_SDK_ASSERT_RANGE(length, 0, BufferSize);
    NN_UNUSED(length);
    this->m_Buffer += str;
    return *this;
}

StringStream& StringStream::operator<<(const void* ptr) NN_NOEXCEPT
{
    char str[BufferSize];
    int length = nn::util::SNPrintf(str, BufferSize, "%P", ptr);
    NN_SDK_ASSERT_RANGE(length, 0, BufferSize);
    NN_UNUSED(length);
    this->m_Buffer += str;
    return *this;
}

StringStream& StringStream::write(const char* s, StreamSize n) NN_NOEXCEPT
{
    this->m_Buffer.append(s, n);
    return *this;
}

}}} // namespace nnt::testing::detail
