﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nnt/gtest/detail/gtest-heap.h>
#include <nnt/gtest/detail/gtest-string.h>

namespace nnt { namespace testing { namespace detail {

class StringStream final
{
public:
    NNT_TESTING_DETAIL_HEAP_IS_ALLOCATABLE();

private:
    String m_Buffer;

public:
    StringStream() NN_NOEXCEPT : m_Buffer() {}

    typedef size_t StreamSize;

    StringStream& operator<<(int8_t value) NN_NOEXCEPT
    {
        return (*this << static_cast<long long>(value));
    }

    StringStream& operator<<(short value) NN_NOEXCEPT
    {
        return (*this << static_cast<long long>(value));
    }

    StringStream& operator<<(int value) NN_NOEXCEPT
    {
        return (*this << static_cast<long long>(value));
    }

    StringStream& operator<<(long value) NN_NOEXCEPT
    {
        return (*this << static_cast<long long>(value));
    }

    StringStream& operator<<(long long value) NN_NOEXCEPT;

    StringStream& operator<<(uint8_t value) NN_NOEXCEPT
    {
        return (*this << static_cast<unsigned long long>(value));
    }

    StringStream& operator<<(unsigned short value) NN_NOEXCEPT
    {
        return (*this << static_cast<unsigned long long>(value));
    }

    StringStream& operator<<(unsigned int value) NN_NOEXCEPT
    {
        return (*this << static_cast<unsigned long long>(value));
    }

    StringStream& operator<<(unsigned long value) NN_NOEXCEPT
    {
        return (*this << static_cast<unsigned long long>(value));
    }

    StringStream& operator<<(unsigned long long value) NN_NOEXCEPT;

    StringStream& operator<<(double value) NN_NOEXCEPT;

    StringStream& operator<<(float value) NN_NOEXCEPT;

    StringStream& operator<<(std::nullptr_t) NN_NOEXCEPT
    {
        this->m_Buffer += "nullptr";
        return *this;
    }

    StringStream& operator<<(const void* ptr) NN_NOEXCEPT;

    StringStream& operator<<(char c) NN_NOEXCEPT
    {
        this->m_Buffer += c;
        return *this;
    }

    StringStream& operator<<(const char* str) NN_NOEXCEPT
    {
        this->m_Buffer += str;
        return *this;
    }

    StringStream& operator<<(const String& str) NN_NOEXCEPT
    {
        this->m_Buffer += str;
        return *this;
    }

    StringStream& operator<<(StringStream& (*pf)(StringStream&)) NN_NOEXCEPT
    {
        return pf(*this);
    }

    StringStream& write(const char* s, StreamSize n) NN_NOEXCEPT;

    String str() const NN_NOEXCEPT
    {
        return String(this->m_Buffer);
    }

    void str(const String& str) NN_NOEXCEPT
    {
        this->m_Buffer.assign(str);
    }

private:
    NN_DISALLOW_COPY(StringStream);
    NN_DISALLOW_MOVE(StringStream);
};

}}} // namespace nnt::testing::detail
