﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace UtilExtension
{
    public static class DistinctExtension
    {
        public static IEnumerable<T> Distinct<T, TKey>(this IEnumerable<T> source, Func<T, TKey> selector, DistinctBy type)
        {
            return source.GroupBy(selector).Select(
                    e => type == DistinctBy.First ? e.First() : e.Last()
                );
        }

        public enum DistinctBy
        {
            First,
            Last
        }
    }
}
