﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Text.RegularExpressions;

namespace Util
{
    public class RenameUtil
    {
        public static string AddFirmwareVersion(string FilePath, string Version)
        {
            var filename = Path.GetFileName(FilePath);

            if(NspInfo.FileNameFormat.IsMatch(filename))
            {
                // 既にバージョンが付与されている場合はそのまま返す
                return filename;
            }

            return string.Format("{0}.{1}.nsp", Path.GetFileNameWithoutExtension(filename), Version);
        }

        public static string GetOceanFileNameForDeveloper(string FilePath)
        {
            var filename = Path.GetFileName(FilePath);

            if (OceanFileNameFormatForDeveloper.IsMatch(filename))
            {
                var info = OceanFileNameFormatForDeveloper.Match(filename).Groups;

                return string.Format("{0}Dev{1}_sdkuser.nsp", info["name"], info["ocean_info"]);
            }

            // リネーム対象でなければそのまま返す
            return filename;
        }

        private static readonly Regex OceanFileNameFormatForDeveloper = new Regex(@"(?<name>.*?)(?<ocean_info>_.*)_sdkuser\.nsp");
    }
}
