﻿// The purpose of this test is to validate the expression parser can correctly
// drill down into globals that are externally defined.
//
// This test has several test cases:
// 1) The class "ExternalClass" is defined in two places, ExternalClass.h and
// and ExternalClass2.h. Each definition is different but is not namespaced. Both
// definitions can exist simultaneously in separate compile units. Review the
// globals g_pExternalClass and g_pExternalClass2 and verify the correct classes
// are returned in the watch window. You can set breakpoints in the two global
// functions, or within the ExternalClass functions.
//
// 2) There are two separately namespaced global structs called "DataWrapper."
// Verify the correct definition is retrieved for both globals g_DW and g_DW2.
//
// 3) Should you question the results of the watch window, you can assign the
// global double g_pDouble and verify the results are what you expect.
//
// Caveats:
// 1) Win32 does not handle all scenarios correctly. Specifically the two
// ExternalClass definitions. It picks one and defines both global variables as
// that type.
//
// 2) The compiler may have issues as well. This is still being debugged.
//
// 3) The compiler will not allow virtual functions of the same name within a
// classes with the same names. It will also not allow two definitions of a class
// within the same compile unit. Should two functions be declared as inline, the
// compiler will pick one of the inline functions and insert that definition
// when called. This matches Win32 behavior.
//
// 4) When in doubt, copy the source to a Win32 project.

extern void GlobalFunction( void );
extern void GlobalFunction2( void );

double* g_pDouble;

namespace NS1
{
    class           GlobalClass;
    GlobalClass*    CreateGlobalClass();
    void            DestroyGlobalClass( GlobalClass* pGlobalClass );
}
namespace NS2
{
    class           GlobalClass;
    GlobalClass*    CreateGlobalClass();
    void            DestroyGlobalClass( GlobalClass* pGlobalClass );
}
#ifndef __NX__
    int main( int argc, char** argv )
#else
    extern "C" void nnMain( int argc )
#endif
    {
        g_pDouble = new double( );

        NS1::GlobalClass* pGlobalClass1 = NS1::CreateGlobalClass();
        NS2::GlobalClass* pGlobalClass2 = NS2::CreateGlobalClass();

        while( true ) // DeclarationsTestBP01
        {
            GlobalFunction( ); //BreakpointMultiFileProjectKey00
            GlobalFunction2( ); //BreakpointMultiFileProjectKey10
        }

        NS1::DestroyGlobalClass( pGlobalClass1 );
        NS2::DestroyGlobalClass( pGlobalClass2 );

        delete g_pDouble;
#ifndef __NX__
        return 0;
#endif
    }
