﻿//==============================================================================
//
//==============================================================================

#pragma once

//==============================================================================

void    Common_Init();
void    Common_Close();

//==============================================================================
// Common function signatures
typedef void    (*TestDLL_ReturnVoidProc)();
typedef void    (*TestDLL_ReturnVoidIntArgProc)( int );
typedef int     (*TestDLL_ReturnNumberProc)();
typedef void    (*TestDLL_ChangeStringProc)( char*, int32_t );
typedef float   (*TestDLL_ReturnWorkProc)( int );
typedef void    (*SleepProc)( int32_t );


//==============================================================================
// Common test calls
class dll_code;

void    Common_TestDLLVoidCall          ( dll_code*     pModule,
                                          const char*   pFunctionName );

void    Common_TestDLLVoidIntArgCall    ( dll_code*     pModule,
                                          const char*   pFunctionName,
                                          int           Value );

int     Common_TestDLLReturnIntCall     ( dll_code*     pModule,
                                          const char*   pFunctionName );

bool    Common_TestDLLChangeStringCall  ( dll_code*     pModule,
                                          const char*   pFunctionName,
                                          char*         pString,
                                          int32_t       Value );

float   Common_TestDLLWorkCall          ( dll_code*     pModule,
                                          const char*   pFunctionName,
                                          int           Value );

void    Common_TestDLLSleepCall         ( dll_code*     pModule,
                                          const char*   pFunctionName,
                                          int           Duration );

//==============================================================================

// Macro version of function, for tests in which we do not wish to add another
// function on to the call stack.

#define Common_DLLReturnVoidMacro(pModule, pFunctionName, FuncSignature, ...) \
{                                                                             \
    uintptr_t ProcAddress;                                                    \
    if (pModule->FindSymbol(&ProcAddress, pFunctionName))                     \
    {                                                                         \
        FuncSignature pCall = (FuncSignature)ProcAddress;                     \
        pCall(__VA_ARGS__);                                                   \
    }                                                                         \
    else                                                                      \
    {                                                                         \
        REPORT("Unable to find %s\n", pFunctionName);                         \
    }                                                                         \
}
