﻿// Code to demonstrate debugging in C

#include <stdio.h>

extern unsigned __int128 simd_test_c(void* Vec0, void* Vec1, void* Vec2, void* Vec3);

union VECTOR_REGISTER
{
    unsigned __int128   Q[1];
    unsigned long long  X[2];
    unsigned long       W[4];
    unsigned short      H[8];
    unsigned char       B[16];
    double              D[2];
    float               S[4];
};

void cTest()
{
    union VECTOR_REGISTER Vec0;
    union VECTOR_REGISTER Vec1;
    union VECTOR_REGISTER Vec2;
    union VECTOR_REGISTER Vec3;
    union VECTOR_REGISTER RetVal;

    Vec0.Q[0] = 0;
    Vec1.Q[0] = 0;
    Vec2.Q[0] = 0;
    Vec3.Q[0] = 0;

    printf("\nInput Vector from C:\n\n");
    for (int i = 0; i < 4; i++)
    {
        Vec0.S[i] = i + 1;
        printf("Vec0.W[%d] = %08X, Vec0.S[%d] = %G\n", i, Vec0.W[i], i, Vec0.S[i]);
    }

    RetVal.Q[0] = simd_test_c( &Vec0, &Vec1, &Vec2, &Vec3 );

    printf("\nOutput Vectors from C:\n\n");
    for (int i = 0; i < 4; i++)
    {
        printf("Vec0.W[%d] = %08X, Vec0.S[%d] = %G\n", i, Vec0.W[i], i, Vec0.S[i]);
    }

    printf("\n");
    for (int i = 0; i < 4; i++)
    {
        printf("Vec1.W[%d] = %08X, Vec1.S[%d] = %G\n", i, Vec1.W[i], i, Vec1.S[i]);
    }

    printf("\n");
    for (int i = 0; i < 4; i++)
    {
        printf("Vec2.W[%d] = %08X, Vec2.S[%d] = %G\n", i, Vec2.W[i], i, Vec2.S[i]);
    }

    printf("\n");
    for (int i = 0; i < 4; i++)
    {
        printf("Vec3.W[%d] = %08X, Vec3.S[%d] = %G\n", i, Vec3.W[i], i, Vec3.S[i]);
    }
}
