﻿//==============================================================================
//  Copyright (C) DejaTools, LLC.  All rights reserved.
//==============================================================================

#pragma once

void MyMain( int argc, char** argv );

#ifndef CAFE
    #include <stdio.h>
    #include <stdint.h>
#else
    #include <cafe.h>
    typedef unsigned char uint8_t;
    extern "C" int DejaStage_ProcessStop(void);
#endif

#ifdef __NX__
#include <cstdarg>
#include <cstdlib>
#include <nn\nn_Log.h>
#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#endif

//==============================================================================

static void Trace( int Value )
{
#if CAFE
    OSReport( "%x\n", Value );
#elif defined( __NX__ )
    NN_LOG( "%p\n", (void*)Value );
#else
    printf( "%x\n", Value );
#endif
}

//==============================================================================

static void Trace( const char* pValue )
{
#ifdef CAFE
    OSReport( "%s\n", pValue );
#elif defined __NX__
    NN_LOG( "%s\n", pValue );
#else
    printf( "%s\n", pValue );
#endif
}

//==============================================================================

static bool ProcessStop( void )
{
#ifdef CAFE
    return DejaStage_ProcessStop();
#else
    return false;
#endif
}

//==============================================================================

#if defined( __NX__ )

    #include "mem_mgr.h"
    static void DebugSetup( int argc, char** argv )
    {
        tiny_memmgr_init();
    }
#else

    static void DebugSetup( int argc, char** argv )
    {
    }
#endif

//==============================================================================
