﻿#pragma once
#include <stdint.h>

//==============================================================================
// Fake ELF data
//==============================================================================

//==============================================================================
// Type defs
//==============================================================================

typedef          uint8_t    u8;         // unsigned  8-bit integer
typedef          int8_t     s8;         //   signed  8-bit integer
typedef          uint16_t   u16;        // unsigned 16-bit integer
typedef          int16_t    s16;        //   signed 16-bit integer
typedef          uint32_t   u32;        // unsigned 32-bit integer
typedef          int32_t    s32;        //   signed 32-bit integer
typedef          uint64_t   u64;        // unsigned 64-bit integer
typedef          int64_t    s64;        //   signed 64-bit integer
typedef          float      f32;        //          32-bit float
typedef          double     f64;        //          64-bit float (double)

typedef unsigned long packed_color;

const long long int         TheNegativeConstLongLongInt = 0xFF00FF00FF00FF00;
const long long int         ThePositiveConstLongLongInt = 0x7F00FF00FF00FF00;
const unsigned int          TheConstUInt        = 0xFF00FF00;
const double                TheConstDouble      = -1.0;
const float                 TheConstFloat       = -1.0f;
const char                  TheConstChar        = 'a';
const short                 TheConstShort       = 1;
const wchar_t               TheConstWCharT      = L'a';
const unsigned long         TheConstULong       = 0xFF00FF00FF00FF00;
const unsigned long long    TheConstULongLong   = 0xFF00FF00FF00FF00;
const bool                  TheConstBool        = true;

enum LocalTestEnum
{
    LTE_TEST1 = 1,
    LTE_TEST2,
    LTE_TEST3,
    LTE_TEST4,
    LTE_TEST5
};

//==============================================================================
// Structures
//==============================================================================


struct BitField
{
    unsigned int A:8;
    unsigned int B:8;
    unsigned int C:8;
    long long int D : 40;
};

struct BitfieldX
{
    signed int A : 12;
    unsigned int B : 12;
    signed int C : 5;
    unsigned int D : 5;
    unsigned char E : 4;
};

struct vector3
{
public:
    float       x;                                                      // X.
    float       y;                                                      // Y.
    float       z;                                                      // Z.
};

struct vertex_pc
{
    vector3         Position;
    packed_color    Color;
};

struct color
{
    color() {};
    color( int aR, int aG, int aB, int aA = 255 )
    {
        R = (unsigned char)aR;
        G = (unsigned char)aG;
        B = (unsigned char)aB;
        A = (unsigned char)aA;
    };

    unsigned char R;
    unsigned char G;
    unsigned char B;
    unsigned char A;
};

struct cell
{
    int         m_i;
    int         m_j;
    vector3     m_Base[7];
};

struct CellContainer
{
    cell** m_pCells;
};

//==============================================================================

struct UnionTest_Anonymous
{
    int control;

    union
    {
        int int0;
        float float0;
    };
};

struct UnionTest_Named
{
    int control;

    union InternalUnion
    {
        int int0;
        float float0;
    } internal;
};

//==============================================================================

class ComplexAnonymous
{
public:
    int m_ValueNU;

    struct{
        unsigned int m_StructU;
        int m_StructI;

        struct {
            short m_StructSA;
            unsigned short m_StructSB;
        };
    };

    union {
        unsigned int m_DataU;
        int m_DataI;

        union {
            short m_DataSA;
            unsigned short m_DataSB;
        };
    };
};

//==============================================================================
// classes
//==============================================================================

class test_class
{
public:
    s32     x;
    s32     y;

    test_class* pNext;
};

//==============================================================================

class obj_mgr
{
public:
                    obj_mgr         ( void );
        void        Init            ( int Count );
static  void        SetId           ( long long Value );
static  long long   GetId           ( void );
        void        AddToTypes      ( int Value );

protected:

static  long long   s_UniqueStaticID;
        bool        m_Initialized;
        int         m_NextSlot;
static  int*        s_TypeData[ 8 ];
typedef struct { int m_Int; } AnonymousIntStruct;
static AnonymousIntStruct s_AIS;
static  struct { int m_Int; } s_AIS2;
};

//==============================================================================

// Various anonymous and typdef structs and unions.
static const struct { int m_Int; } s_AIS3 = { 3 };
static const union  { int m_Int; } s_AIU1 = { 1 };

namespace NS1
{
    static const struct { int m_Int; } s_AIS4 = { 4 };
}

namespace NS2
{
    static const struct NamedStruct
    {
        typedef struct { int NestedInt; } NestedStruct;
        typedef int TypedefInt;

        int                         m_Int;
        NestedStruct                m_NestedStruct;
        struct { int NestedInt; }   m_Struct;
    } s_IS1 = { 5, { 55 }, { 555 } };
}

typedef NS2::NamedStruct TypedefStructArray[2];

namespace NS3
{
    namespace NS4
    {
        static const TypedefStructArray s_IS2 = { { 6 }, { 7 } };
    }
}

//==============================================================================

class ChildClass
{
public:
    ChildClass( ){ TheInt = 42; };
    ChildClass( int Int ){ TheInt = Int; };
    int TheInt;

};

class ParentContainsMember
{
public:
    ParentContainsMember( ){};
    ChildClass m_Child;
};

class ParentContainsPointer
{
public:
    ParentContainsPointer( ){ m_pChild = new ChildClass(42); };
    ChildClass* m_pChild;
};

class ParentContainsArray
{
public:
    ParentContainsArray( ){};
    ChildClass m_ChildArray[2];
};

class ParentContainsPointerArray
{
public:
    ParentContainsPointerArray( ){ m_pChildArray[0] = new ChildClass(42); m_pChildArray[1] = new ChildClass(43); };
    ChildClass* m_pChildArray[2];
};

//==============================================================================

class DataWrapper1
{
public:
    class DataWrapperImpl
    {
    public:
        DataWrapperImpl( ) : m_TheInt( 0 ), m_TheFloat( 0.0 ), m_pThis( nullptr ){};
    public:
        int                 m_TheInt;
        float               m_TheFloat;
        DataWrapperImpl*    m_pThis;
    };
    DataWrapper1( ) : m_Impl()
    {
        m_Impl.m_TheInt     = 1;
        m_Impl.m_TheFloat   = 1.0;
        m_Impl.m_pThis      = &(this->m_Impl);
    }
public:
    DataWrapperImpl m_Impl;
};

class DataWrapper2
{
public:
    class DataWrapperImpl
    {
    public:
        DataWrapperImpl( ) : m_TheLongLong( 0 ), m_TheDouble( 0.0 ), m_pThis( nullptr ){};
    public:
        long long           m_TheLongLong;
        double              m_TheDouble;
        DataWrapperImpl*    m_pThis;
    };
    DataWrapper2( ) : m_Impl()
    {
        m_Impl.m_TheLongLong    = 2;
        m_Impl.m_TheDouble      = 2.0;
        m_Impl.m_pThis          = &(this->m_Impl);
    }
public:
    DataWrapperImpl m_Impl;
};

//==============================================================================
// Test case as defined by SIGLONTD-4398: http://spdlybra.nintendo.co.jp/jira/browse/SIGLONTD-4398

typedef struct
{
    int data;
}
GUID;

static int Test(GUID *guid)
{
    return 0;
}

struct API
{
    int( *func )( GUID *guid );
};

//==============================================================================

struct EmptyStruct
{

};

//==============================================================================

class iObject
{
public:
    iObject(){};
};

class IntObject : public iObject
{
public:
    IntObject( int Int )
    {
        m_Value = Int;
    };
private:
    int m_Value;
};

class PiObject : public iObject
{
public:
    PiObject( iObject* pObj )
    {
        m_pValue = pObj;
    };
private:
    iObject* m_pValue;
};

class Container
{
public:
    Container( int Int )
    {
        m_pIObject = new IntObject( Int );
    };
    Container( iObject* pObj )
    {
        m_pIObject = new PiObject( pObj );
    };

private:
    Container(){};
    iObject* m_pIObject;
};

//==============================================================================
