﻿//==============================================================================
//  Copyright (C) Deja Tools, LLC.  All rights reserved.
//==============================================================================

//==============================================================================
//
//  Main entry for ARMREFSimpleTest
//
//==============================================================================

#include <memory.h>
#include "../print.h"

extern void SetVariableCInFileC( int iVariableFileC_A );
extern void ChangeParameterA( int& iParameterA );

static int g_iVariableG = 1234;

#ifndef __NX__
int main(int argc, char** argv)
#else
extern "C" void nnMain(void)
#endif
{
    int            iVariableA              = 0xA;                        // value: "0x0000000a;10"
    int            iVariableB              = 0xAc;                       // value: "0x000000ac;172"
    int            iVariableC              = 0xAce;                      // value: "0x00000ace;2766"
    int            iVariableD              = 0xAceD;                     // value: "0x0000aced;44269"
    int            iVariableE              = 0xAceDe;                    // value: "0x000acede;708318"
    int            iVariableF              = 0xAceDec;                   // value: "0x00acedec;11333100"
    int            iVariableG              = 0xAceDeca;                  // value: "0x0acedeca;181329610"
    int            iVariableH              = 0xAceDecad;                 // value: "0xacedecad;-1393693523"
    int            iVariableI              = (int)0xAceDecade;           // value: "0xcedecade;-824259874"
    int            iVariableJ              = (int)4294967295;            // value: -1
    int            iVariableK              = (int)4294967296;            // value: 0
    int            iVariableL              = (int)4294967297;            // value: 1
    float          fVariable_nA            = -0.0f;                      // value:  "-0.0"
    float          fVariable_nB            = -1.0f;                      // value: "-1.0"
    float          fVariable_nC            = -1.2f;                      // value: "-1.2"
    float          fVariable_nD            = -1.23f;                     // value: "-1.23"
    float          fVariable_nE            = -1.234f;                    // value: "-1.234"
    float          fVariable_nF            = -1.2345f;                   // value: "-1.2345"
    float          fVariable_nG            = -1.23456f;                  // value: "-1.23456"
    float          fVariable_nHTruncated   = -1.234567890123456f;        // this will get truncated to: -1.23457
    float          fVariable_nITruncated   = -1.234564321012345f;        // this will get truncated to: -1.23456
    float          fVariable_pA            =  0.0f;                      // value:  "0.0"
    float          fVariable_pB            =  1.0f;                      // value:  "1.0"
    float          fVariable_pC            =  1.2f;                      // value:  "1.2"
    float          fVariable_pD            =  1.23f;                     // value:  "1.23"
    float          fVariable_pE            =  1.234f;                    // value:  "1.234"
    float          fVariable_pF            =  1.2345f;                   // value:  "1.2345"
    float          fVariable_pG            =  1.23456f;                  // value:  "1.23456"
    float          fVariable_pHTruncated   =  1.234567890123456f;        // this will get truncated to:  1.23457
    float          fVariable_pITruncated   =  1.234564321012345f;        // this will get truncated to:  1.23456
    double         dVariable_nA           = -1.000001;                   // value: -1.000001
    double         dVariable_nB           = -1.0000001;                  // value: -1.0000001
    double         dVariable_nC           = -1.00000001;                 // value: -1.00000001
    double         dVariable_nD           = -1.000000001;                // value: -1.000000001
    double         dVariable_nE           = -1.0000000001;               // value: -1.0000000001
    double         dVariable_nF           = -1.00000000001;              // value: -1.00000000001
    double         dVariable_nG           = -1.000000000001;             // value: -1.000000000001
    double         dVariable_nH           = -1.0000000000001;            // value: -1.0000000000001
    double         dVariable_nI           = -1.00000000000001;           // value: -1.00000000000001
    double         dVariable_nJ           = -1.000000000000001;          // value: -1.0
    double         dVariable_nK           = -1.0000000000000001;         // value: -1.0
    double         dVariable_nL           = -1.00000000000000001;        // value: -1.0
    double         dVariable_nM           = 1234567890123456789;         // value: 1.2345678901234568e+018
    double         dVariable_nN           = 0.000000000001234567890123456789; // value: 1.2345678901234569e-012
    short          sVariable_nA           = -1;                          // value: -1
    short          sVariable_nB           = -12;                         // value: -12
    short          sVariable_nC           = -123;                        // value: -123
    short          sVariable_nD           = -1234;                       // value: -1234
    short          sVariable_nE           = -12345;                      // value: -12345
    short          sVariable_nF           = (short)-123456;              // this will end up as (short)0xfffe1dc0, which yields: 0x1dc0 (7616)
    short          sVariable_nGConversion = (short)-65535;               // this will end up as value: 1 (the - negates the -1)
    short          sVariable_nHConversion = (short)-65536;               // this will end up as value: 0
    short          sVariable_nIConversion = (short)-65537;               // this will end up as value: -1
    short          sVariable_pA           = 1;                           // value: 1
    short          sVariable_pB           = 12;                          // value: 12
    short          sVariable_pC           = 123;                         // value: 123
    short          sVariable_pD           = 1234;                        // value: 1234
    short          sVariable_pE           = 12345;                       // value: 12345
    short          sVariable_pF           = (short)123456;               // this will end up as (short)0x0001e240, which yields: 0xe240 (-7616)
    short          sVariable_pGConversion = (short)65535;                // this will end up as value: -1
    short          sVariable_pHConversion = (short)65536;                // this will end up as value: 0
    short          sVariable_pIConversion = (short)65537;                // this will end up as value: 1
    char           cVariable_nA           = -1;                          // value: 255
    char           cVariable_nB           = -12;                         // value: 244
    char           cVariable_nC           = -123;                        // value: 133
    char           cVariable_nDConversion = (char)-1234;                 // this will end up as (char)0x000004d2, which yields: -0xd2 (--46 or 46)
    char           cVariable_nEConversion = (char)-255;                  // this will end up as value: 1
    char           cVariable_nFConversion = (char)-256;                  // this will end up as value: 0
    char           cVariable_nGConversion = (char)-257;                  // this will end up as value: 255
    char           cVariable_pA           = 1;                           // value: 1
    char           cVariable_pB           = 12;                          // value: 12
    char           cVariable_pC           = 123;                         // value: 123
    char           cVariable_pDConversion = (char)1234;                  // this will end up as (char)0x000004d2, which yields: 0xd2 (210)
    char           cVariable_pEConversion = (char)255;                   // this will end up as value: 255
    char           cVariable_pFConversion = (char)256;                   // this will end up as value: 0
    char           cVariable_pGConversion = (char)257;                   // this will end up as value: 1
    long           lVariable_nA           = -1;                          // value: -1
    long           lVariable_nB           = -1234567890;                 // value: -1234567890
    long           lVariable_nCConversion = (long)-12345678901;          // this will end up as (long)0x2dfdc1c35, which yields: -0xdfdc1c35 (--539222987 or 539222987)
    long           lVariable_nDConversion = -(long)4294967295;           // this will end up as value: 1 (the - negates the -1)
    long           lVariable_nEConversion = (long)-4294967296;           // this will end up as value: 0
    long           lVariable_nFConversion = (long)-4294967297;           // this will end up as value: -1
    long           lVariable_pA           = 1;                           // value: 1
    long           lVariable_pB           = 1234567890;                  // value: 1234567890
    long           lVariable_pCConversion = (long)12345678901;           // this will end up as (long)0x2dfdc1c35, which yields: 0xdfdc1c35 (-539222987)
    long           lVariable_pDConversion = (long)4294967295;            // this will end up as value: -1
    long           lVariable_pEConversion = (long)4294967296;            // this will end up as value: 0
    long           lVariable_pFConversion = (long)4294967297;            // this will end up as value: 1
    unsigned char  ucVariableA            = (unsigned char)-1;           // value: 255
    unsigned char  ucVariableB            = (unsigned char)-2;           // value: 254
    unsigned char  ucVariableC            = (unsigned char)-255;         // value: 1
    unsigned char  ucVariableD            = (unsigned char)-256;         // value: 0
    unsigned char  ucVariableE            = (unsigned char)-511;         // value: 1
    unsigned char  ucVariableF            = (unsigned char)-512;         // value: 0
    unsigned char  ucVariableG            = (unsigned char)255;          // value: 255
    unsigned char  ucVariableH            = (unsigned char)256;          // value: 0
    unsigned char  ucVariableI            = (unsigned char)257;          // value: 1
    unsigned short usVariableA            = (unsigned short)-1;          // value: 65535
    unsigned short usVariableB            = (unsigned short)-2;          // value: 65534
    unsigned short usVariableC            = (unsigned short)-65535;      // value: 1
    unsigned short usVariableD            = (unsigned short)-65534;      // value: 2
    unsigned short usVariableE            = (unsigned short)-131072;     // value: 0
    unsigned short usVariableF            = (unsigned short)-131071;     // value: 1
    unsigned short usVariableG            = (unsigned short)-131070;     // value: 2
    unsigned short usVariableH            = (unsigned short)-131069;     // value: 3
    unsigned short usVariableI            = (unsigned short)1;           // value: 1
    unsigned short usVariableJ            = (unsigned short)2;           // value: 2
    unsigned short usVariableK            = (unsigned short)65535;       // value: 65535
    unsigned short usVariableL            = (unsigned short)65536;       // value: 0
    unsigned short usVariableM            = (unsigned short)65537;       // value: 1
    unsigned short usVariableN            = (unsigned short)131072;      // value: 0
    unsigned short usVariableO            = (unsigned short)131071;      // value: 65535
    unsigned short usVariableP            = (unsigned short)131070;      // value: 65534
    unsigned int   uiVariableA            = (unsigned int)-1;            // value: 4294967295
    unsigned int   uiVariableB            = (unsigned int)-2;            // value: 4294967295
    unsigned int   uiVariableC            = (unsigned int)4294967295;    // value: 4294967295
    unsigned int   uiVariableD            = (unsigned int)-4294967296;   // value: 0
    unsigned int   uiVariableE            = (unsigned int)-4294967297;   // value: 4294967295
    unsigned int   uiVariableF            = (unsigned int)-4294967298;   // value: 4294967294
    unsigned int   uiVariableG            = (unsigned int)4294967295;    // value: 4294967295
    unsigned int   uiVariableH            = (unsigned int)4294967296;    // value: 0
    unsigned int   uiVariableI            = (unsigned int)4294967297;    // value: 1
    unsigned long  ulVariableA            = (unsigned long)-1;           // value: 4294967295
    unsigned long  ulVariableB            = (unsigned long)-1234567890;  // value: 3060399406
    unsigned long  ulVariableC            = (unsigned long)-12345678901; // this will end up as (long)-0x2dfdc1c35, which yields: -0xdfdc1c35 (539222987)
    unsigned long  ulVariableD            = (unsigned long)4294967295;   // this will end up as value: 4294967295
    unsigned long  ulVariableE            = (unsigned long)-4294967296;  // this will end up as value: 0
    unsigned long  ulVariableF            = (unsigned long)-4294967297;  // this will end up as value: 4294967295
    unsigned long  ulVariableG            = 1;                           // value: 1
    unsigned long  ulVariableH            = 1234567890;                  // value: 1234567890
    unsigned long  ulVariableI            = (unsigned long)12345678901;  // this will end up as (long)0x2dfdc1c35, which yields: 0xdfdc1c35 (3755744309)
    unsigned long  ulVariableJ            = (unsigned long)4294967295;   // this will end up as value: 4294967295
    unsigned long  ulVariableK            = (unsigned long)4294967296;   // this will end up as value: 0
    unsigned long  ulVariableL            = (unsigned long)4294967297;   // this will end up as value: 1
    long long      sllVariableA           = 4294967295;                  // value: 4294967295
    long long      sllVariableB           = 4294967296;                  // value: 0
    long long      sllVariableC           = 4294967297;                  // value: -1
    long long      sllVariableD           = -4294967295;                 // value: -4294967295
    unsigned long long ullVariableA       = 4294967295*4294967295;       //
    unsigned long long ullVariableB       = (4294967295*4294967295) + 10;//
    unsigned long long ullVariableC       = 4294967296*4294967296;       // value: 0
    int&                riVariableA       = iVariableA;                  // value: "0x0000000a;10"
    int&                riVariableB       = iVariableB;                  // value: "0x000000ac;172"
    float&              rfVariable_nA     = fVariable_nA;                // value:  "-0.0"
    double&             rdVariable_nA     = dVariable_nA;                // value: -1.000001
    short&              rsVariable_nA     = sVariable_nA;                // value: -1
    char&               rcVariable_nA     = cVariable_nA;                // value: 255
    long&               rlVariable_nA     = lVariable_nA;                // value: -1
    unsigned char&      rucVariableA      = ucVariableA;                 // value: 255
    unsigned short&     rusVariableA      = usVariableA;                 // value: 65535
    unsigned int&       ruiVariableA      = uiVariableA;                 // value: 4294967295
    unsigned long&      rulVariableA      = ulVariableA;                 // value: 18446744073709551615
    long long&          rsllVariableA     = sllVariableA;                // value: 4294967295
    unsigned long long& rullVariableA     = ullVariableA;                //

    PRINT( "Running program from " __FILE__ "\n" );

    // ------------------------------------
    // Test: Set a variable in another file
    // ------------------------------------

    SetVariableCInFileC( 'S' );

    // ------------------------------------
    // Test: 1) main(..) scoped variable iParameterA gets changed by a function.
    //       2) proper scoping applied to iParameterA.

    // "main(..) scoped variable: iParameterA             (scope 0)
    int iParameterA = 15;
    ChangeParameterA( iParameterA );

    int dummy_iVariableA_Scope_0;
    dummy_iVariableA_Scope_0 = 0;

    {
        // Test: local variable with the same name as an outer variable.
        // Local scoped variable: iParameterA             (scope 1)
        int iParameterA = 255;
        ChangeParameterA( iParameterA );
        int dummy_iVariableA_Scope_1;
        dummy_iVariableA_Scope_1 = 0;

        {
            // Test: local variable with the same name as outer scoped variables.
            // Local scoped variable: iParameterA         (scope 2)
            int iParameterA = 13;
            ChangeParameterA( iParameterA );
            int dummy_iVariableA_Scope_2;
            dummy_iVariableA_Scope_2 = 0;

            {
                // Test: local variable with the same name as outer scoped variables.
                // Local scoped variable: iParameterA     (scope 3)
                int iParameterA = 19;
                ChangeParameterA( iParameterA );
                int dummy_iVariableA_Scope_3;
                dummy_iVariableA_Scope_3 = 0;

                {
                    // Test: local variable with the same name as outer scoped variables.
                    // Local scoped variable: iParameterA (scope 4)
                    int iParameterA = -127;
                    ChangeParameterA( iParameterA );
                    int dummy_iVariableA_Scope_4;
                    dummy_iVariableA_Scope_4 = 0;
                }
            }
        }
    }

    dummy_iVariableA_Scope_0 = 0;

    // ------------------------------------
    // Test: invalid floating point numbers.
    //       #DEN, #INF, #NAN
    //       These tests are cheated by using an integer with a staged value
    //       that gets casted to a float variable.  The purpose of doing it
    //       this way is to prevent division on the RefTarget.exe, which can
    //       cause it to crash.
    int   iDEN         = 0x00000009;              // hex value of: 1.261e-044#DEN
    int   iPositiveINF = 0x7f800000;              // hex value of: 1.#INF0000
    int   iNegativeINF = 0xff800000;              // hex value of: -1.#INF0000
    int   iQNAN        = 0xffffffff;              // hex value of: -1.#QNAN000
    float fDEN         = *(float *)&iDEN;         // should be: 1.261e-044#DEN
    float fPositiveINF = *(float *)&iPositiveINF; // should be: 1.#INF0000
    float fNegativeINF = *(float *)&iNegativeINF; // should be: -1.#INF0000
    float fQNAN        = *(float *)&iQNAN;        // should be: -1.#QNAN000

    int dummyValueToLetMeSetABreakpointToTest_BadFloatTest_03;
    dummyValueToLetMeSetABreakpointToTest_BadFloatTest_03 = 0;

    // ------------------------------------
    // Test: invalid double point numbers.
    //       #DEN, #INF, #NAN
    //       These tests are cheated by using an integer with a staged value
    //       that gets casted to a float variable.  The purpose of doing it
    //       this way is to prevent division on the RefTarget.exe, which can
    //       cause it to crash.
    long long llDEN         = 0x000000000003d017;                    // hex value of: 1.234566295172e-318#DEN
    long long llPositiveINF = 0x7ff0000000000000;                    // hex value of: 1.#INF000000000000
    long long llNegativeINF = 0xfff0000000000000;                    // hex value of: -1.#INF000000000000
    long long llQNAN        = 0xffffffffffffffff;                    // hex value of: -1.#QNAN00000000000
    double dDEN;
    double dPositiveINF;
    double dNegativeINF;
    double dQNAN;
    memcpy( &dDEN,         &llDEN,         sizeof(llDEN) );          // should be: 1.234566295172e-318#DEN
    memcpy( &dPositiveINF, &llPositiveINF, sizeof(llPositiveINF) );  // should be: 1.#INF000000000000
    memcpy( &dNegativeINF, &llNegativeINF, sizeof(llNegativeINF) );  // should be: -1.#INF000000000000
    memcpy( &dQNAN,        &llQNAN,        sizeof(llQNAN) );         // should be: -1.#QNAN00000000000

    int dummyValueToLetMeSetABreakpointToTest_BadFloatTest_04;
    dummyValueToLetMeSetABreakpointToTest_BadFloatTest_04 = 0;

    // ------------------------------------
    // Dummy stuff - might be useful later.

    int loopIteration = 0;
    bool bStop = false;
    while( !bStop ) // BasicLocalsTestBP01
    {
        loopIteration++;
    }

#ifndef __NX__
    return 0;
#endif
}

