﻿//==============================================================================
//
//  Main entry for DataStructuresTestProj
//
//==============================================================================



#include "../print.h"

struct TestBitfield
{
    signed int A : 12;
    unsigned int B : 12;
    signed int C : 5;
    unsigned int D : 5;
    unsigned int E : 5;
};

union TestUnion
{
    unsigned int intValue;
    short charValue[2];
};

void UpdateBitfield(TestBitfield& Bitfield);

#ifndef __NX__
int main(int argc, char** argv)
#else
extern "C" void nnMain( void )
#endif
{
    const int MAX = 5;
    bool ContLoop = true;
    int Counter = 0;
    int NumLoops = 0;
    //Arrays and Pointers to Arrays and Pointers
    short simple_array[MAX];
    short (*pPtrToArray)[MAX];
    short* simple_ptr_array[MAX];
    short* (*pPtrToPtrArray)[MAX];
    short** double_ptr_array[MAX];
    short** (*pPtrToDoublePtrArray)[MAX];
    //Bitfields
    TestBitfield BitfieldA;
    //Unions
    TestUnion TestA, TestB;
    //Strings
    const char* simple_string = "foobar";
    const wchar_t* wide_string = L"foobar";
    char simple_string_array[7] = "foobar";
    wchar_t wide_string_array[7] = L"foobar";

    PRINT( "Running program from " __FILE__ "\n" );

    TestA.intValue = 546218967;

    TestB.charValue[0] = TestA.charValue[1];
    TestB.charValue[1] = TestA.charValue[0];

    BitfieldA.A = -1;
    BitfieldA.B = 85;
    BitfieldA.C = 5;
    BitfieldA.D = 18;
    BitfieldA.E = 3;

    for (int Count = 0; Count < MAX; Count++)
    {
        simple_array[Count] = (Count * Count) + 3;
        simple_ptr_array[Count] = &simple_array[Count];
        double_ptr_array[Count] = &simple_ptr_array[Count];
    }
    pPtrToArray = &simple_array;
    pPtrToPtrArray = &simple_ptr_array;
    pPtrToDoublePtrArray = &double_ptr_array;

    while( ContLoop )
    {
        UpdateBitfield( BitfieldA );

        simple_array[Counter] = ( Counter * Counter ) + NumLoops;

        Counter++;
        NumLoops++;

        if( Counter >= MAX )
        {
            Counter = 0;
            BitfieldA.B = 1024;
        }

        if( Counter < 2 )
        {
            TestA.charValue[1-Counter] += NumLoops;
            TestB.charValue[Counter] -= NumLoops;
        }

        if( NumLoops > 5000 )
        {
            ContLoop = false;
        }
    }

#ifndef __NX__
    return 0;
#endif
}

void UpdateBitfield( TestBitfield& Bitfield )
{
    Bitfield.A = Bitfield.C * -1;
    Bitfield.B = Bitfield.B + Bitfield.A;
    Bitfield.C = (char)( Bitfield.A + Bitfield.E );
    Bitfield.D = (char)( Bitfield.C - 1 );
    Bitfield.E++;
}
