:: ---------------------------------------------------------------------------
:: Copyright (C) Nintendo Co., Ltd.  All rights reserved.
::
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.
:: ---------------------------------------------------------------------------

@echo off
setlocal enabledelayedexpansion

set SDK_ROOT_DIR=%~dp0..

::-------------------------------------------------------------------------------
:: バッチファイルに与えられた引数をインストールすべきカスタムウィザードへの
:: パスとみなし、インストールルーチンを呼び出します。
::-------------------------------------------------------------------------------

:: テンプレートのインストールを実行
if not "%*" == "" (
    call :checkfile "%*"
    call :install "%*"
) else (
    rem  インストールするテンプレートディレクトリが指定されていません。終了します。
    echo Not specified wizard directories to copy. Exiting.
)

endlocal

:: 終了
exit /b


::-------------------------------------------------------------------------------
:install
::-------------------------------------------------------------------------------

:::: Visual Studio 2012 のプロジェクトテンプレート格納先をレジストリから取得
::set vs2012Reg=HKCU\Software\Microsoft\VisualStudio\11.0
::for /f "usebackq tokens=*" %%i in (`reg query "%vs2012Reg%" /v VisualStudioLocation`) do set vs2012RegValue=%%i
::
:::: レジストリの値が見つかれば、インストールを行う
::if not "%vs2012RegValue%" == "" (
::    call :install_for_vs "%~1" "%vs2012RegValue:VisualStudioLocation    REG_EXPAND_SZ    =%" 11.0
::) else (
::    rem  Visual Studio 2012 が見つかりませんでした。テンプレートのインストールをスキップします。
::    echo Could not detect Visual Studio 2012 installation. Skipping template copying.
::)

:::: Visual Studio 2013 のプロジェクトテンプレート格納先をレジストリから取得
::set vs2013Reg=HKCU\Software\Microsoft\VisualStudio\12.0
::for /f "usebackq tokens=*" %%i in (`reg query "%vs2013Reg%" /v VisualStudioLocation`) do set vs2013RegValue=%%i
::
:::: レジストリの値が見つかれば、インストールを行う
::if not "%vs2013RegValue%" == "" (
::    call :install_for_vs "%~1" "%vs2013RegValue:VisualStudioLocation    REG_EXPAND_SZ    =%" 12.0
::) else (
::    rem  Visual Studio 2012 が見つかりませんでした。テンプレートのインストールをスキップします。
::    echo Could not detect Visual Studio 2013 installation. Skipping template copying.
::)

:: Visual Studio 2015 のプロジェクトテンプレート格納先をレジストリから取得
set vs2015Reg=HKCU\Software\Microsoft\VisualStudio\14.0
for /f "usebackq tokens=*" %%i in (`reg query "%vs2015Reg%" /v VisualStudioLocation`) do set vs2015RegValue=%%i

:: レジストリの値が見つかれば、インストールを行う
if not "%vs2015RegValue%" == "" (
    call :install_for_vs "%~1" "%vs2015RegValue:VisualStudioLocation    REG_EXPAND_SZ    =%" 14.0
) else (
    rem  Visual Studio 2015 が見つかりませんでした。テンプレートのインストールをスキップします。
    echo Could not detect Visual Studio 2015 installation. Skipping template copying.
)

:: Visual Studio 2017 のプロジェクトテンプレート格納先を取得する
call :GetWizardDestinationDirectory "" 15.0
set vs2017InstallDir=%WIZARD_DESTINATION_BASE_DIRECTORY%
if not "%vs2017InstallDir%" == "" (
    call :install_for_vs "%~1" "%vs2017InstallDir%" 15.0
) else (
    rem  Visual Studio 2017 が見つかりませんでした。テンプレートのインストールをスキップします。
    echo Could not detect Visual Studio 2017 installation. Skipping template copying.
)


:: 終了
exit /b


::-------------------------------------------------------------------------------
:install_for_vs
::-------------------------------------------------------------------------------

:: 各インストール先ディレクトリを定義
set installDirName=NintendoSDK
set installWizardDir=%~2\Wizards\%installDirName%
set installBodyDir=%~2\%installDirName%\CustomWizard\
set vsVersion=%~3

rem %installWizardDir% にvszファイル等をインストールします。
echo Copying vsz file to "%installWizardDir%"
rem %installBodyDir% にウィザード本体をインストールします
echo Copying wizard body to "%installBodyDir%"

:: 親ディレクトリの存在確認
if not exist "%installWizardDir%" (
    mkdir "%installWizardDir%"
)
if not exist "%installBodyDir%" (
    mkdir "%installBodyDir%"
)

:: テンプレートをインストール
for %%D in (%~1) do (
    rem 既にインストールされている場合は一旦削除
    if exist "%installBodyDir%\%%~nD\" (
        rmdir "%installBodyDir%\%%~nD\" /s /q
        if not %ERRORLEVEL% == 0 (
            rem  "%installBodyDir%\%%~nD\" の削除に失敗しました。
            echo Failed to ve "%installBodyDir%\%%~nD\"
            exit /b
        )
    )
    rem  %%~nD をインストールします。
    echo Copying %%~nD
    xcopy "%%D\%%~nD.ico" "%installWizardDir%\" /q /r /y
    xcopy "%%D\%%~nD.vsdir" "%installWizardDir%\" /q /r /y
    rem xcopy "%%D\%%~nD.vsz" "%installWizardDir%\" /q /r /y
	if exist "%installWizardDir%\%%~nD.vsz" (
        del /Q "%installWizardDir%\%%~nD.vsz"
	)
    for /f "usebackq delims= eol= " %%i in ( %%D\%%~nD.vsz ) do (
        set line=%%i
        set line=!line:WIZARDBODYPATH=%installBodyDir%%%~nD!
        set line=!line:WIZARDVSVERSION=%vsVersion%!
        >> "%installWizardDir%\%%~nD.vsz" echo !line!
    )
    xcopy "%%D" "%installBodyDir%\%%~nD\" /q /e /y
    if not %ERRORLEVEL% == 0 (
        rem  %%D のインストールに失敗しました。
        echo Failed to copy %%D
    )
)

:: 終了
exit /b


::-------------------------------------------------------------------------------
:checkfile
::-------------------------------------------------------------------------------

for %%D in (%~1) do (
    set fileCheckerPath=%%D\fileChecker.py
    set pythonExePath=%%D\..\..\..\..\Externals\Binaries\Python27\python.exe

    if exist "!fileCheckerPath!" (
        "!pythonExePath!" "!fileCheckerPath!"
        if not !ERRORLEVEL! == 0 (
            echo file check failed, so installation is ABORTED.
            pause
            exit 101
        )
    )
)

:: 終了
exit /b




REM ---- ウィザードのコピー先ディレクトリの取得
REM      (%WIZARD_DESTINATION_BASE_DIRECTORY% に保存されます)
REM %1 ... 取得できなかった場合のデフォルトパス
REM %2 ... VisualStudio のバージョン番号

:GetWizardDestinationDirectory
setlocal enabledelayedexpansion
set DEFAULT_PATH=%1
set VS_VERSION=%2

set WIZARD_DESTINATION_BASE_DIRECTORY=

rem set TARGET_REGISTORY_KEY=
rem set TARGET_REGISTORY_VALUE=VisualStudioLocation
set TARGET_REGISTRY_DATA=
set VS_INSTANCE_ID=

if "%VS_VERSION%"=="12.0" (
    call :GetRegistryData HKCU\Software\Microsoft\VisualStudio\12.0 VisualStudioLocation
) else if "%VS_VERSION%"=="14.0" (
    call :GetRegistryData HKCU\Software\Microsoft\VisualStudio\14.0 VisualStudioLocation
) else if "%VS_VERSION%"=="15.0" (
    call :GetVsInstanceId 15.0
    call :GetRegistryDataFromHive VisualStudioLocation 15.0 !VS_INSTANCE_ID!
) else (
    endlocal
    exit /b 1
)

REM ---- %USERPROFILE%の展開処理
echo set TARGET_REGISTRY_DATA="%TARGET_REGISTRY_DATA%">temp.bat
call temp.bat
del temp.bat

set WIZARD_DESTINATION_BASE_DIRECTORY=%TARGET_REGISTRY_DATA%

if %WIZARD_DESTINATION_BASE_DIRECTORY% == "" (
    set WIZARD_DESTINATION_BASE_DIRECTORY=%DEFAULT_PATH%
)
set WIZARD_DESTINATION_BASE_DIRECTORY=%WIZARD_DESTINATION_BASE_DIRECTORY:"=%

endlocal & (set WIZARD_DESTINATION_BASE_DIRECTORY=%WIZARD_DESTINATION_BASE_DIRECTORY%)

exit /b 0


REM ---- Visual Studio の InstanceId を取得する (VS2017対応)
REM      (%2 に保存されます)
REM %1 ... VisualStudio のバージョン番号
REM %2 ... [出力] Visual Studio の InstanceId

:GetVsInstanceId
setlocal enabledelayedexpansion
set VS_VERSION=%1

set VSWHERE_VERSION_STRING=

if "%VS_VERSION%" == "15.0" (
    set VSWHERE_VERSION_STRING=[15.0,16.0^)
)

rem set VSWHERE_PATH="C:\Program Files (x86)\Microsoft Visual Studio\Installer\vswhere.exe"
set VSWHERE_PATH=%SDK_ROOT_DIR%\Externals\Binaries\vswhere\vswhere.exe
if not exist %VSWHERE_PATH% (
    endlocal
    exit /b 1
)

set INSTANCE_ID=
for /f "usebackq delims=" %%a in (`%VSWHERE_PATH% -format value -property instanceId -version !VSWHERE_VERSION_STRING! -products Microsoft.VisualStudio.Product.Professional`) do set INSTANCE_ID=%%a

if "%INSTANCE_ID%" == "" (
    echo Visual Studio v%VS_VERSION% Professional is not installed.
    endlocal
    exit /b 1
)

endlocal & (set VS_INSTANCE_ID=%INSTANCE_ID%)

exit /b 0


REM ---- レジストリハイブから値を取得する (VS2017対応)
REM      (%TARGET_REGISTRY_DATA% に保存されます)
REM %1 ... レジストリ値名
REM %2 ... VisualStudio のバージョン番号
REM %3 ... VisualStudio の instanceId

:GetRegistryDataFromHive
rem setlocal enabledelayedexpansion
set REGISTRY_VALUE=%1
set VS_VERSION=%2
set VS_INSTANCE_ID=%3

rem set VSREGCONFIG_PATH=%SDK_ROOT_DIR%\Tools\Install\VsRegConfig.exe
set VSREGCONFIG_PATH=%SDK_ROOT_DIR%\Externals\SetupToolBinaries\bin\VsRegConfig\VsRegConfig.exe

rem for /f "usebackq delims=" %%a in (`"%VSREGCONFIG_PATH%" !REGISTRY_VALUE! !VS_VERSION! !VS_INSTANCE_ID!`) do set TARGET_REGISTRY_DATA=%%a
for /f "usebackq delims=" %%a in (`"%VSREGCONFIG_PATH%" %REGISTRY_VALUE% %VS_VERSION% %VS_INSTANCE_ID%`) do set TARGET_REGISTRY_DATA=%%a

rem endlocal
exit /b 0
