﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*

// BEGIN__HARVEST_EXCEPTION_ZSTRING

<javascriptresource>
<name>Nintendo Export Texture</name>
<menu>automate</menu>
<type>automate</type>
<enableinfo>in (PSHOP_ImageMode, GrayScaleMode, IndexedMode, RGBMode, CMYKMode, Gray32Mode, RGB96Mode)</enableinfo>
<eventid>089EADC3-FCB9-40D0-919C-0A225CAD4E77</eventid>
<category>Nintendo</category>
</javascriptresource>

// END__HARVEST_EXCEPTION_ZSTRING

*/

#strict on
#target photoshop

#include "./NintendoExportTextureFunc.jsxinc"

//-----------------------------------------------------------------------------
//! @brief メイン関数です。
//-----------------------------------------------------------------------------
function main()
{
	//-----------------------------------------------------------------------------
	// test
	//var str = "arg: " + arguments.length; for (var i = 0; i < arguments.length; ++i) str += arguments[i] + " (" + typeof(arguments[i]) + ")\n"; alert(str);
	//return;

	//-----------------------------------------------------------------------------
	// bring to front
	app.bringToFront(); // CS2-

	//-----------------------------------------------------------------------------
	// get document
	if (app.documents.length == 0)
	{
		alert("Please open a PSD file to export");
		return;
	}
	var doc = app.activeDocument;
	if (doc.name.GetExtensionFromFilePath() != "psd")
	{
		alert("Please open a PSD file to export");
		return;
	}

	//-----------------------------------------------------------------------------
	// オプション設定をドキュメントからロードします。
	var opts = new Object();
	var valid = LoadSettings(opts, doc);
	//alert("valid opt: " + valid);
	if (valid)
	{
		//-----------------------------------------------------------------------------
		// 正しいオプション設定が存在すればテクスチャ中間ファイルを出力します。
		if (opts.m_SavePsd)
		{
			SaveSettings(doc, opts);
		}
		DoExport(doc, opts);
	}
	else if ($.getenv("NINTENDO_PHOTOSHOP_BATCH") == "1")
	{
		//-----------------------------------------------------------------------------
		// バッチ Export で正しいオプション設定が存在しなければ何もしません。
		var errorPath = $.getenv("NINTENDO_PHOTOSHOP_BATCH_ERROR");
		if (errorPath != null && errorPath.length != 0)
		{
			SaveTextToFile(errorPath, "No export texture settings\n", false);
		}
	}
	else
	{
		//-----------------------------------------------------------------------------
		// 正しいオプション設定が存在しなければダイアログを表示します。
		if (DoDialog(opts, doc))
		{
			//-----------------------------------------------------------------------------
			// OK がクリックされたらオプション設定を保存してテクスチャ中間ファイルを出力します。
			SaveSettings(doc, opts);
			DoExport(doc, opts);
		}
	}
}

// 定規の単位を pixels にして main を呼びます。
CallFunctionUnitsPixels(main);

