﻿/// <header>
///   <version>0.0.0</version>
/// </header>

/// <tag name="Convert">
///   <func id="ConvV4ToV3"/>
/// </tag>
/// <func id="ConvV4ToV3" name="ConvV4ToV3">
///   <in name="v4" type="vec4"/>
///   <return type="vec3"/>
///   <description>vec4 から vec3 を抽出</description>
/// </func>
/// <block guid="{7C94EB0B-B09A-439D-955A-47660F4942B6}" displayname="V4 => V3 [xyz]">
///   <func id="ConvV4ToV3"/>
///   <out displayname="xyz" type="vec3" target="return"/>
///   <in displayname="xyzw" type="vec4" target="v4"/>
/// </block>
/// <code funcid="ConvV4ToV3">
vec3 ConvV4ToV3( vec4 v4 )
{
  return v4.xyz;
}
/// </code>

/// <tag name="Convert">
///   <func id="ConvV4ToV2"/>
/// </tag>
/// <func id="ConvV4ToV2" name="ConvV4ToV2">
///   <in name="v4" type="vec4"/>
///   <return type="vec2"/>
///   <description>vec4 から vec2(xy) を抽出</description>
/// </func>
/// <block guid="{7C94EB0B-B09A-439D-955A-47650F4842B6}" displayname="V4 => V2 [xy]">
///   <func id="ConvV4ToV2"/>
///   <out displayname="xy" type="vec2" target="return"/>
///   <in displayname="xyzw" type="vec4" target="v4"/>
/// </block>
/// <code funcid="ConvV4ToV2">
vec2 ConvV4ToV2( vec4 v4 )
{
  return v4.xy;
}
/// </code>

/// <tag name="Convert">
///   <func id="ConvV4ToV2_XW"/>
/// </tag>
/// <func id="ConvV4ToV2_XW" name="ConvV4ToV2_XW">
///   <in name="v4" type="vec4"/>
///   <return type="vec2"/>
///   <description>vec4 から vec2(xw) を抽出</description>
/// </func>
/// <block guid="{7C94EB0B-B09A-439D-955A-47650F4842B7}" displayname="V4 => V2 [xw]">
///   <func id="ConvV4ToV2_XW"/>
///   <out displayname="xw" type="vec2" target="return"/>
///   <in displayname="xyzw" type="vec4" target="v4"/>
/// </block>
/// <code funcid="ConvV4ToV2_XW">
vec2 ConvV4ToV2_XW( vec4 v4 )
{
  return v4.xw;
}
/// </code>

/// <tag name="Convert">
///   <func id="ConvV3ToV4_0"/>
/// </tag>
/// <func id="ConvV3ToV4_0" name="ConvV3ToV4_0">
///   <in name="v3" type="vec3"/>
///   <return type="vec4"/>
///   <description>vec3 を w=0 とした vec4 に変換</description>
/// </func>
/// <block guid="{7C94EB1B-B09A-439D-955A-47650F4842B5}" displayname="V3 => V4 [0]">
///   <func id="ConvV3ToV4_0"/>
///   <out displayname="xyz0" type="vec4" target="return"/>
///   <in displayname="xyz" type="vec3" target="v3"/>
/// </block>
/// <code funcid="ConvV3ToV4_0">
vec4 ConvV3ToV4_0( vec3 v3 )
{
  return vec4( v3, 0 );
}
/// </code>

/// <tag name="Convert">
///   <func id="ConvV3ToV4_1"/>
/// </tag>
/// <func id="ConvV3ToV4_1" name="ConvV3ToV4_1">
///   <in name="v3" type="vec3"/>
///   <return type="vec4"/>
///   <description>vec3 を w=1 とした vec4 に変換</description>
/// </func>
/// <block guid="{7C94EB0B-B09A-439D-955A-47651F4842B5}" displayname="V3 => V4 [1]">
///   <func id="ConvV3ToV4_1"/>
///   <out displayname="xyz1" type="vec4" target="return"/>
///   <in displayname="xyz" type="vec3" target="v3"/>
/// </block>
/// <code funcid="ConvV3ToV4_1">
vec4 ConvV3ToV4_1( vec3 v3 )
{
  return vec4( v3, 1 );
}
/// </code>

/// <tag name="Convert">
///   <func id="ConvV2ToV4_0"/>
/// </tag>
/// <func id="ConvV2ToV4_0" name="ConvV2ToV4_0">
///   <in name="v2" type="vec2"/>
///   <return type="vec4"/>
///   <description>vec2 を z=0, w=0 とした vec4 に変換</description>
/// </func>
/// <block guid="{7C94EB0B-B09A-439D-956A-47650F4842B5}" displayname="V2 => V4 [00]">
///   <func id="ConvV2ToV4_0"/>
///   <out displayname="xy00" type="vec4" target="return"/>
///   <in displayname="xy" type="vec2" target="v2"/>
/// </block>
/// <code funcid="ConvV2ToV4_0">
vec4 ConvV2ToV4_0( vec2 v2 )
{
  return vec4( v2, 0, 0 );
}
/// </code>

/// <tag name="Convert">
///   <func id="ConvV2ToV4_01"/>
/// </tag>
/// <func id="ConvV2ToV4_01" name="ConvV2ToV4_01">
///   <in name="v2" type="vec2"/>
///   <return type="vec4"/>
///   <description>vec2 を z=0, w=1 とした vec4 に変換</description>
/// </func>
/// <block guid="{FD3D2595-FBC9-4D16-8B78-50189DC96B30}" displayname="V2 => V4 [01]">
///   <func id="ConvV2ToV4_01"/>
///   <out displayname="xy01" type="vec4" target="return"/>
///   <in displayname="xy" type="vec2" target="v2"/>
/// </block>
/// <code funcid="ConvV2ToV4_01">
vec4 ConvV2ToV4_01( vec2 v2 )
{
  return vec4( v2, 0, 1 );
}
/// </code>

/// <tag name="Convert">
///   <func id="ConvV2ToV4_1"/>
/// </tag>
/// <func id="ConvV2ToV4_1" name="ConvV2ToV4_1">
///   <in name="v2" type="vec2"/>
///   <return type="vec4"/>
///   <description>vec2 を z=1, w=1 とした vec4 に変換</description>
/// </func>
/// <block guid="{7C94EB0B-B09A-439D-955A-47650F4842B5}" displayname="V2 => V4 [11]">
///   <func id="ConvV2ToV4_1"/>
///   <out displayname="xy11" type="vec4" target="return"/>
///   <in displayname="xy" type="vec2" target="v2"/>
/// </block>
/// <code funcid="ConvV2ToV4_1">
vec4 ConvV2ToV4_1( vec2 v2 )
{
  return vec4( v2, 1, 1 );
}
/// </code>

/// <tag name="Convert">
///   <func id="ConvFloatToV4_1"/>
/// </tag>
/// <func id="ConvFloatToV4_1" name="ConvFloatToV4_1">
///   <in name="v1" type="float"/>
///   <return type="vec4"/>
///   <description>float を x = v1, y = v1, z=v1, w=1 とした vec4 に変換</description>
/// </func>
/// <block guid="{2E09BAA6-F5E9-4CE0-AEB0-6A681639FC6A}" displayname="V1 => V4 [vvv1]">
///   <func id="ConvFloatToV4_1"/>
///   <out displayname="vvv1" type="vec4" target="return"/>
///   <in displayname="v" type="float" target="v1"/>
/// </block>
/// <code funcid="ConvFloatToV4_1">
vec4 ConvFloatToV4_1( float v1 )
{
  return vec4( v1, v1, v1, 1);
}
/// </code>

/// <tag name="Convert">
///   <func id="WorldToTangentSpace"/>
/// </tag>
/// <func id="WorldToTangentSpace" name="WorldToTangentSpace">
///   <out name="eye_dir" type="vec3"/>
///   <out name="light_dir" type="vec3"/>
///   <out name="out_N" type="vec3"/>
///   <in name="light_pos" type="vec3"/>
///   <description>ワールド上の位置を接空間に変換します</description>
/// </func>
/// <block guid="{081E96AA-485B-43DF-AD42-9D5213AEC177}" displayname="WorldToTangentSpace">
///   <func id="WorldToTangentSpace"/>
///   <out displayname="eye_dir" type="vec3" target="eye_dir"/>
///   <out displayname="light_dir" type="vec3" target="light_dir"/>
///   <out displayname="out_N" type="vec3" target="out_N"/>
///   <in displayname="light_pos" type="vec3" target="light_pos"/>
/// </block>
/// <code funcid="WorldToTangentSpace">
void WorldToTangentSpace( out vec3 eye_dir, out vec3 light_dir, out vec3 out_N, vec3 light_pos )
{
    const vec3 pain_N = vec3(0.0, 0.0, 1.0);    // ペインの法線ベクトル

    vec3 position = vec3(modelM[0].w, modelM[1].w, modelM[2].w);
    vec3 eye_pos = vec3(cameraPosition);

    mat3 mW = mat3(modelM[0].xyz, modelM[1].xyz, modelM[2].xyz);

    vec3 P = position.xyz;
    vec3 N = pain_N;
    vec3 E = normalize(P - eye_pos);           // 視線位置へのベクトル
    vec3 L = normalize(light_pos - P);

    // 接ベクトル空間を求める
    vec3 tangent = cross(vec3(0.0, 1.0, 0.0), N);
    vec3 binormal = cross(N, tangent);

    // 接空間マトリクス[column-major-matrix(行優先)] 初期化。
    // [00(x-axis), 01(y-axis), 02(z-axis) ]
    // [10(x-axis), 11(y-axis), 12(z-axis) ]
    // [20(x-axis), 21(y-axis), 22(z-axis) ]
    mat3 tangentToWorldSpace;
#if 1
    // 転置された状態の初期化を行う。
    tangentToWorldSpace = mat3(
        normalize(mW * tangent),     // first column
        normalize(mW * binormal),    // second column
        normalize(mW * N)            // third column
    );
    // 既に転置された状態なので、そのまま利用する
    mat3 worldToTangentSpace = tangentToWorldSpace;
#else
    vec3 x_axis = normalize(mW * tangent);
    vec3 y_axis = normalize(mW * binormal);
    vec3 z_axis = normalize(mW * N);

    tangentToWorldSpace[0][0] = x_axis.x;
    tangentToWorldSpace[1][0] = x_axis.y;
    tangentToWorldSpace[2][0] = x_axis.z;
    tangentToWorldSpace[0][1] = y_axis.x;
    tangentToWorldSpace[1][1] = y_axis.y;
    tangentToWorldSpace[2][1] = y_axis.z;
    tangentToWorldSpace[0][2] = z_axis.x;
    tangentToWorldSpace[1][2] = z_axis.y;
    tangentToWorldSpace[2][2] = z_axis.z;

    // ※直交行列：転置が元の行列の逆行列になる、但しペインのモデルマトリックスはスケールが入ると、直交行列では無くなるので注意
    // https://ja.wikipedia.org/wiki/%E8%BB%A2%E7%BD%AE%E8%A1%8C%E5%88%97
    mat3 worldToTangentSpace = transpose(tangentToWorldSpace);
#endif

    // ワールドの配置された視点、ライトを接空間に置き換える
    eye_dir = normalize(worldToTangentSpace * E);
    light_dir = normalize(worldToTangentSpace * L);
    out_N = normalize(N);
}
/// </code>

/// <tag name="Convert">
///   <func id="WorldToTangentSpaceLight"/>
/// </tag>
/// <func id="WorldToTangentSpaceLight" name="WorldToTangentSpaceLight">
///   <out name="eye_dir" type="vec3"/>
///   <in name="light_pos" type="vec3"/>
///   <description>ワールド上のライトを接空間に変換します</description>
/// </func>
/// <block guid="{B0DF1F3D-D578-4C05-8CB3-E78533A8BB74}" displayname="WorldToTangentSpaceLight">
///   <func id="WorldToTangentSpaceLight"/>
///   <out displayname="eye_dir" type="vec3" target="eye_dir"/>
///   <in displayname="light_pos" type="vec3" target="light_pos"/>
/// </block>
/// <code funcid="WorldToTangentSpaceLight">
void WorldToTangentSpaceLight( out vec3 eye_dir, vec3 light_pos )
{
    vec3 eye_pos = vec3(cameraPosition);
    vec3 position = vec3(modelM[0].w, modelM[1].w, modelM[2].w);

    vec3 N = vec3(0.0, 0.0, 1.0);     // ペインの法線方向、固定として用意
    vec3 P = position.xyz;
    vec3 L = normalize(light_pos.xyz - P);

    mat3 mW = mat3(modelM[0].xyz, modelM[1].xyz, modelM[2].xyz);

    // 接ベクトル空間を求める
    // ※ N=vec3(0.0, 1.0, 0.0) の場合にY軸が無くなってしまう問題があるが、今回は法線の向きは固定なので考慮をしません。
    vec3 tangent = cross(vec3(0.0, 1.0, 0.0), N);
    vec3 binormal = cross(N, tangent);

    // 接空間マトリクス[column-major-matrix(行優先)] 初期化。
    // [00(x-axis), 01(y-axis), 02(z-axis) ]
    // [10(x-axis), 11(y-axis), 12(z-axis) ]
    // [20(x-axis), 21(y-axis), 22(z-axis) ]
    mat3 tangentToWorldSpace;
#if 1
    // 転置された状態の初期化を行う。
    tangentToWorldSpace = mat3(
        normalize(mW * tangent),     // first column
        normalize(mW * binormal),    // second column
        normalize(mW * N)            // third column
    );
    mat3 worldToTangentSpace = tangentToWorldSpace;
#else
    vec3 x_axis = normalize(mW * tangent);
    vec3 y_axis = normalize(mW * binormal);
    vec3 z_axis = normalize(mW * N);

    tangentToWorldSpace[0][0] = x_axis.x;
    tangentToWorldSpace[1][0] = x_axis.y;
    tangentToWorldSpace[2][0] = x_axis.z;
    tangentToWorldSpace[0][1] = y_axis.x;
    tangentToWorldSpace[1][1] = y_axis.y;
    tangentToWorldSpace[2][1] = y_axis.z;
    tangentToWorldSpace[0][2] = z_axis.x;
    tangentToWorldSpace[1][2] = z_axis.y;
    tangentToWorldSpace[2][2] = z_axis.z;

    // ※直交行列：転置が元の行列の逆行列になる、但しペインのモデルマトリックスはスケールが入ると、直交行列では無くなるので注意
    // https://ja.wikipedia.org/wiki/%E8%BB%A2%E7%BD%AE%E8%A1%8C%E5%88%97
    mat3 worldToTangentSpace = transpose(tangentToWorldSpace);
#endif

    // 接空間のライトベクトルに変換
    eye_dir = normalize(worldToTangentSpace * L);
}
/// </code>

