﻿/// <header>
///   <version>0.0.0</version>
///   <options>
///     <option name="CodeOutputCondition" value="Always"/>
///   </options>
/// </header>

/// <tag name="Math">
///   <func id="IntegerFF"/>
/// </tag>
/// <func id="IntegerFF" name="IntegerFF">
///   <in name="f" type="float"/>
///   <return type="float"/>
///   <description>整数部分を抽出</description>
/// </func>
/// <block guid="{58922780-4DFC-4E94-85E4-150A92743A9F}" displayname="Integer">
///   <func id="IntegerFF"/>
///   <out displayname="return" type="float" target="return"/>
///   <in displayname="x" type="float" target="f"/>
/// </block>
/// <code funcid="IntegerFF">
float IntegerFF( float f )
{
  return f - fract( f );
}
/// </code>

/// <tag name="Math">
///   <func id="GetReflect3"/>
/// </tag>
/// <func id="GetReflect3" name="GetReflect3">
///   <in name="dir" type="vec3"/>
///   <in name="norm" type="vec3"/>
///   <return type="vec3"/>
///   <description>入射角 vec3 と法線 norm3 から反射ベクトルを出力</description>
/// </func>
/// <block guid="{48933682-4DFC-4E96-85E5-150A93754A9F}" displayname="Reflect">
///   <func id="GetReflect3"/>
///   <out displayname="return" type="vec3" target="return"/>
///   <in displayname="vec3" type="vec3" target="dir"/>
///   <in displayname="norm3" type="vec3" target="norm"/>
/// </block>
/// <code funcid="GetReflect3">
vec3 GetReflect3( vec3 dir, vec3 norm )
{
  return reflect( dir, norm );
}
/// </code>

/// <tag name="Math">
///   <func id="GetReflect3_NoRev"/>
/// </tag>
/// <func id="GetReflect3_NoRev" name="GetReflect3_NoRev">
///   <in name="dir" type="vec3"/>
///   <in name="norm" type="vec3"/>
///   <return type="vec3"/>
///   <description>反射ベクトルを出力（逆向きの場合0ベクトルを返す）</description>
/// </func>
/// <block guid="{48933683-4DFC-4E96-85E5-150A93754A9F}" displayname="Reflect(Ignore Reverse)">
///   <func id="GetReflect3_NoRev"/>
///   <out displayname="return" type="vec3" target="return"/>
///   <in displayname="vec3" type="vec3" target="dir"/>
///   <in displayname="norm3" type="vec3" target="norm"/>
/// </block>
/// <code funcid="GetReflect3_NoRev">
vec3 GetReflect3_NoRev( vec3 dir, vec3 norm )
{
  // I - 2.0 * dot(N, I) * N
  float d = dot( norm, dir );
  // Ignore reverse side
  if( d < 0 ){ return dir - 2 * d * norm; }
  else{ return vec3( 0, 0, 0 ); }
}
/// </code>

/// <tag name="Math">
///   <func id="GetRefract"/>
/// </tag>
/// <func id="GetRefract" name="GetRefract">
///   <in name="vec" type="vec3"/>
///   <in name="norm" type="vec3"/>
///   <in name="n" type="float"/>
///   <return type="vec3"/>
///   <description>入射角 vec3 と法線 norm3 、屈折率から屈折ベクトルを出力。入射ベクトルは正規化済みの想定。</description>
/// </func>
/// <block guid="{F95F45F9-7F8F-460B-9A44-1C4E7EF96E1A}" displayname="Refract">
///   <func id="GetRefract"/>
///   <out displayname="return" type="vec3" target="return"/>
///   <in displayname="vec3" type="vec3" target="vec"/>
///   <in displayname="norm3" type="vec3" target="norm"/>
///   <in displayname="n" type="float" target="n"/>
/// </block>
/// <code funcid="GetRefract">
vec3 GetRefract( vec3 vec, vec3 norm, float n )
{
  return refract( vec, norm, n );
}
/// </code>

/// <tag name="Math">
///   <func id="GetPI"/>
/// </tag>
/// <func id="GetPI" name="GetPI">
///   <return type="float"/>
///   <description>円周率（3.1415…）を取得します</description>
/// </func>
/// <block guid="{1B760945-2CD6-4CCE-8BA0-C9C2E1689A22}" displayname="PI">
///   <func id="GetPI"/>
///   <out displayname="PI" type="float" target="return"/>
/// </block>
/// <code funcid="GetPI">
float GetPI()
{
    return M_PI;
}
/// </code>

/// <tag name="Math">
///   <func id="GetDegToRad"/>
/// </tag>
/// <func id="GetDegToRad" name="GetDegToRad">
///   <in name="degree" type="float"/>
///   <return type="float"/>
///   <description>角度からラジアンに変換</description>
/// </func>
/// <block guid="{A2644A4B-C078-4BBE-A39E-B1533ED94262}" displayname="DegToRad">
///   <func id="GetDegToRad"/>
///   <out displayname="radian" type="float" target="return"/>
///   <in displayname="degree" type="float" target="degree"/>
/// </block>
/// <code funcid="GetDegToRad">
float GetDegToRad(float degree)
{
  return radians(degree);
}
/// </code>

/// <tag name="Math">
///   <func id="GetRadToDeg"/>
/// </tag>
/// <func id="GetRadToDeg" name="GetRadToDeg">
///   <in name="radian" type="float"/>
///   <return type="float"/>
///   <description>ラジアンから角度に変換</description>
/// </func>
/// <block guid="{55FE765A-460C-4D26-A83C-ACB6C1CAD135}" displayname="RadToDeg">
///   <func id="GetRadToDeg"/>
///   <out displayname="degree" type="float" target="return"/>
///   <in displayname="radian" type="float" target="radian"/>
/// </block>
/// <code funcid="GetRadToDeg">
float GetRadToDeg(float radian)
{
  return degrees(radian);
}
/// </code>

/// <tag name="Math">
///   <func id="GetSinRad"/>
/// </tag>
/// <func id="GetSinRad" name="GetSinRad">
///   <in name="radian" type="float"/>
///   <return type="float"/>
///   <description>Sin 関数（ラジアン）</description>
/// </func>
/// <block guid="{90C899B5-7817-4453-9760-DA78C185FD6F}" displayname="SinRad">
///   <func id="GetSinRad"/>
///   <out displayname="value" type="float" target="return"/>
///   <in displayname="radian" type="float" target="radian"/>
/// </block>
/// <code funcid="GetSinRad">
float GetSinRad(float radian)
{
  return sin(radian);
}
/// </code>

/// <tag name="Math">
///   <func id="GetSinDeg"/>
/// </tag>
/// <func id="GetSinDeg" name="GetSinDeg">
///   <in name="degree" type="float"/>
///   <return type="float"/>
///   <description>Sin 関数（角度）</description>
/// </func>
/// <block guid="{E22B2BD6-079F-41DC-ABC3-A0B73CB8510F}" displayname="SinDeg">
///   <func id="GetSinDeg"/>
///   <out displayname="value" type="float" target="return"/>
///   <in displayname="degree" type="float" target="degree"/>
/// </block>
/// <code funcid="GetSinDeg">
float GetSinDeg(float degree)
{
  return sin(radians(degree));
}
/// </code>

/// <tag name="Math">
///   <func id="GetCosRad"/>
/// </tag>
/// <func id="GetCosRad" name="GetCosRad">
///   <in name="radian" type="float"/>
///   <return type="float"/>
///   <description>Cos 関数（ラジアン）</description>
/// </func>
/// <block guid="{FBB508F4-5DD1-4D23-AD7D-72559629B398}" displayname="CosRad">
///   <func id="GetCosRad"/>
///   <out displayname="value" type="float" target="return"/>
///   <in displayname="radian" type="float" target="radian"/>
/// </block>
/// <code funcid="GetCosRad">
float GetCosRad(float radian)
{
  return cos(radian);
}
/// </code>

/// <tag name="Math">
///   <func id="GetCosDeg"/>
/// </tag>
/// <func id="GetCosDeg" name="GetCosDeg">
///   <in name="degree" type="float"/>
///   <return type="float"/>
///   <description>Cos 関数（角度）</description>
/// </func>
/// <block guid="{7F732ADF-F386-4ABE-9E9E-6A5877F6B7D1}" displayname="CosDeg">
///   <func id="GetCosDeg"/>
///   <out displayname="value" type="float" target="return"/>
///   <in displayname="degree" type="float" target="degree"/>
/// </block>
/// <code funcid="GetCosDeg">
float GetCosDeg(float degree)
{
  return cos(radians(degree));
}
/// </code>

/// <tag name="Math">
///   <func id="GetTanRad"/>
/// </tag>
/// <func id="GetTanRad" name="GetTanRad">
///   <in name="radian" type="float"/>
///   <return type="float"/>
///   <description>Tan 関数（ラジアン）</description>
/// </func>
/// <block guid="{DA8BD6D0-BCCA-4D7F-9E81-3D3D7EF7A7BE}" displayname="TanRad">
///   <func id="GetTanRad"/>
///   <out displayname="value" type="float" target="return"/>
///   <in displayname="radian" type="float" target="radian"/>
/// </block>
/// <code funcid="GetTanRad">
float GetTanRad(float radian)
{
  return tan(radian);
}
/// </code>

/// <tag name="Math">
///   <func id="GetTanDeg"/>
/// </tag>
/// <func id="GetTanDeg" name="GetTanDeg">
///   <in name="degree" type="float"/>
///   <return type="float"/>
///   <description>Tan 関数（角度）</description>
/// </func>
/// <block guid="{47B07DFC-8FA6-4178-BF45-C37B734B7BB4}" displayname="TanDeg">
///   <func id="GetTanDeg"/>
///   <out displayname="value" type="float" target="return"/>
///   <in displayname="degree" type="float" target="degree"/>
/// </block>
/// <code funcid="GetTanDeg">
float GetTanDeg(float degree)
{
  return tan(radians(degree));
}
/// </code>

/// <tag name="Math">
///   <func id="GetArcSinRad"/>
/// </tag>
/// <func id="GetArcSinRad" name="GetArcSinRad">
///   <in name="sinValue" type="float"/>
///   <return type="float"/>
///   <description>ArcSin 関数（ラジアン）</description>
/// </func>
/// <block guid="{718D9EA8-82E9-4814-B0F7-2FF13747F435}" displayname="ArcSinRad">
///   <func id="GetArcSinRad"/>
///   <out displayname="radian" type="float" target="return"/>
///   <in displayname="sinValue" type="float" target="sinValue"/>
/// </block>
/// <code funcid="GetArcSinRad">
float GetArcSinRad( float sinValue )
{
  return asin(sinValue);
}
/// </code>

/// <tag name="Math">
///   <func id="GetArcCosRad"/>
/// </tag>
/// <func id="GetArcCosRad" name="GetArcCosRad">
///   <in name="cosValue" type="float"/>
///   <return type="float"/>
///   <description>ArcCos 関数（ラジアン）</description>
/// </func>
/// <block guid="{47B29DF6-0663-4C9B-9F15-62D7569E5520}" displayname="ArcCosRad">
///   <func id="GetArcCosRad"/>
///   <out displayname="radian" type="float" target="return"/>
///   <in displayname="cosValue" type="float" target="cosValue"/>
/// </block>
/// <code funcid="GetArcCosRad">
float GetArcCosRad( float cosValue )
{
  return acos(cosValue);
}
/// </code>

/// <tag name="Math">
///   <func id="GetArcTanRad"/>
/// </tag>
/// <func id="GetArcTanRad" name="GetArcTanRad">
///   <in name="y" type="float"/>
///   <in name="x" type="float"/>
///   <return type="float"/>
///   <description>ArcTan 関数（ラジアン）</description>
/// </func>
/// <block guid="{854D2D45-C3A4-4453-9813-96970CCD1124}" displayname="ArcTanRad">
///   <func id="GetArcTanRad"/>
///   <out displayname="radian" type="float" target="return"/>
///   <in displayname="y" type="float" target="y"/>
///   <in displayname="x" type="float" target="x"/>
/// </block>
/// <code funcid="GetArcTanRad">
float GetArcTanRad( float y, float x )
{
  return atan(y, x);
}
/// </code>

/// <tag name="Math">
///   <func id="GetSinHRad"/>
/// </tag>
/// <func id="GetSinHRad" name="GetSinHRad">
///   <in name="radian" type="float"/>
///   <return type="float"/>
///   <description>sinh 関数（ラジアン）</description>
/// </func>
/// <block guid="{7B348E5A-00EE-41D1-B6B7-57A406597465}" displayname="SinHRad">
///   <func id="GetSinHRad"/>
///   <out displayname="value" type="float" target="return"/>
///   <in displayname="radian" type="float" target="radian"/>
/// </block>
/// <code funcid="GetSinHRad">
float GetSinHRad( float radian )
{
  return sinh(radian);
}
/// </code>

/// <tag name="Math">
///   <func id="GetCosHRad"/>
/// </tag>
/// <func id="GetCosHRad" name="GetCosHRad">
///   <in name="radian" type="float"/>
///   <return type="float"/>
///   <description>cosh 関数（ラジアン）</description>
/// </func>
/// <block guid="{0D122844-5573-4C82-AE19-B0090B061C3D}" displayname="CosHRad">
///   <func id="GetCosHRad"/>
///   <out displayname="value" type="float" target="return"/>
///   <in displayname="radian" type="float" target="radian"/>
/// </block>
/// <code funcid="GetCosHRad">
float GetCosHRad( float radian )
{
  return cosh(radian);
}
/// </code>

/// <tag name="Math">
///   <func id="GetTanHRad"/>
/// </tag>
/// <func id="GetTanHRad" name="GetTanHRad">
///   <in name="radian" type="float"/>
///   <return type="float"/>
///   <description>tanh 関数（ラジアン）</description>
/// </func>
/// <block guid="{BD1933C1-4D57-4557-BE8C-2C55962CCCB4}" displayname="TanHRad">
///   <func id="GetTanHRad"/>
///   <out displayname="value" type="float" target="return"/>
///   <in displayname="radian" type="float" target="radian"/>
/// </block>
/// <code funcid="GetTanHRad">
float GetTanHRad( float radian )
{
  return tanh(radian);
}
/// </code>

/// <tag name="Math">
///   <func id="GetArcSinHRad"/>
/// </tag>
/// <func id="GetArcSinHRad" name="GetArcSinHRad">
///   <in name="sinhValue" type="float"/>
///   <return type="float"/>
///   <description>asinh 関数（ラジアン）</description>
/// </func>
/// <block guid="{279AC166-0488-4B3B-A06C-9E8B316480CA}" displayname="ArcSinHRad">
///   <func id="GetArcSinHRad"/>
///   <out displayname="radian" type="float" target="return"/>
///   <in displayname="sinhValue" type="float" target="sinhValue"/>
/// </block>
/// <code funcid="GetArcSinHRad">
float GetArcSinHRad( float sinhValue )
{
  return asinh(sinhValue);
}
/// </code>

/// <tag name="Math">
///   <func id="GetArcCosHRad"/>
/// </tag>
/// <func id="GetArcCosHRad" name="GetArcCosHRad">
///   <in name="coshValue" type="float"/>
///   <return type="float"/>
///   <description>acosh 関数（ラジアン）</description>
/// </func>
/// <block guid="{E1D3061D-FBCD-4B59-ACBA-4384C5D647B5}" displayname="ArcCosHRad">
///   <func id="GetArcCosHRad"/>
///   <out displayname="radian" type="float" target="return"/>
///   <in displayname="coshValue" type="float" target="coshValue"/>
/// </block>
/// <code funcid="GetArcCosHRad">
float GetArcCosHRad( float coshValue )
{
  return acosh(coshValue);
}
/// </code>

/// <tag name="Math">
///   <func id="GetArcTanHRad"/>
/// </tag>
/// <func id="GetArcTanHRad" name="GetArcTanHRad">
///   <in name="tanhValue" type="float"/>
///   <return type="float"/>
///   <description>atanh 関数（ラジアン）</description>
/// </func>
/// <block guid="{767DA8EB-7FB6-4A65-8425-D6101A57C117}" displayname="ArcTanHRad">
///   <func id="GetArcTanHRad"/>
///   <out displayname="radian" type="float" target="return"/>
///   <in displayname="tanhValue" type="float" target="tanhValue"/>
/// </block>
/// <code funcid="GetArcTanHRad">
float GetArcTanHRad( float tanhValue )
{
  return atanh(tanhValue);
}
/// </code>

/// <tag name="Math">
///   <func id="GetViewTransform"/>
/// </tag>
/// <func id="GetViewTransform" name="GetViewTransform">
///   <in name="inVec" type="vec4"/>
///   <return type="vec4"/>
///   <description>ビュー座標系に変換します</description>
/// </func>
/// <block guid="{0F53952E-764D-4B0E-925B-04CAF049E448}" displayname="ViewTransform">
///   <func id="GetViewTransform"/>
///   <out displayname="outVec" type="vec4" target="return"/>
///   <in displayname="inVec" type="vec4" target="inVec"/>
/// </block>
/// <code funcid="GetViewTransform">
vec4 GetViewTransform(vec4 inVec)
{
  return inVec * sysViewMatrix;
}
/// </code>

/// <tag name="Math">
///   <func id="GetProjectionTransform"/>
/// </tag>
/// <func id="GetProjectionTransform" name="GetProjectionTransform">
///   <in name="inVec" type="vec4"/>
///   <return type="vec4"/>
///   <description>射影変換を行います</description>
/// </func>
/// <block guid="{797DECCA-7414-4CDF-8949-D182EABAF689}" displayname="ProjectionTransform">
///   <func id="GetProjectionTransform"/>
///   <out displayname="outVec" type="vec4" target="return"/>
///   <in displayname="inVec" type="vec4" target="inVec"/>
/// </block>
/// <code funcid="GetProjectionTransform">
vec4 GetProjectionTransform(vec4 inVec)
{
  return inVec * sysProjectionMatrix;
}
/// </code>

/// <tag name="Math">
///   <func id="GetFMod"/>
/// </tag>
/// <func id="GetFMod" name="GetFMod">
///   <in name="x" type="float"/>
///   <in name="y" type="float"/>
///   <return type="float"/>
///   <description>[非推奨]剰余を出力</description>
/// </func>
/// <block guid="{2E4526F5-2DB2-425D-A7F6-C35D7AFEA300}" displayname="[deprecated]FMod">
///   <func id="GetFMod"/>
///   <out displayname="return" type="float" target="return"/>
///   <in displayname="x" type="float" target="x"/>
///   <in displayname="y" type="float" target="y"/>
/// </block>
/// <code funcid="GetFMod">
float GetFMod( float x, float y )
{
  return mod( x, y );
}
/// </code>

/// <tag name="Math">
///   <func id="FractFF"/>
/// </tag>
/// <func id="FractFF" name="FractFF">
///   <in name="f" type="float"/>
///   <return type="float"/>
///   <description>[非推奨]小数部分を抽出</description>
/// </func>
/// <block guid="{58922679-3DFC-4E94-85E4-150A92743A9F}" displayname="[deprecated]Fract">
///   <func id="FractFF"/>
///   <out displayname="return" type="float" target="return"/>
///   <in displayname="x" type="float" target="f"/>
/// </block>
/// <code funcid="FractFF">
float FractFF( float f )
{
  return fract( f );
}
/// </code>

