﻿#----------------------------------------------------------------------------
# Project:  NintendoWare
#
# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.
#----------------------------------------------------------------------------

# 中間ファイルの更新、System.Xml.XmlDocument 型の doc を更新します
def Update(doc):
	# fsd 以外の <nw4f_3dif> version を 2.0.0 に変更します。
	if not doc.SelectSingleNode("/nw4f_3dif/shader_definition"):
		version = doc.SelectSingleNode("/nw4f_3dif/@version")
		version.Value = "2.0.0"

	# モデルの更新
	if doc.SelectSingleNode("/nw4f_3dif/model"):
		UpdateModel(doc)

	# シェーダコンフィグの更新
	elif doc.SelectSingleNode("/nw4f_3dif/shader_config"):
		UpdateShaderConfig(doc)

#==========================================================
# モデルの更新
def UpdateModel(doc):

	# マテリアルの更新
	for material in doc.SelectNodes("/nw4f_3dif/model/material_array/material"):
		UpdateMaterial(doc, material)

	# 頂点の更新
	for vertex in doc.SelectNodes("/nw4f_3dif/model/vertex_array/vertex"):
		UpdateVertex(doc, vertex)

	# シェイプの更新
	shape_index = 0
	for shape in doc.SelectNodes("/nw4f_3dif/model/shape_array/shape"):
		UpdateShape(doc, shape, shape_index)
		shape_index += 1

#----------------------------------------------------------
# マテリアルの更新
def UpdateMaterial(doc, material):

	# <material_shader_assign> を <shader_assign> に変更します。
	material_shader_assign = material.SelectSingleNode("material_shader_assign")
	if not material_shader_assign:
		return

	shader_assign = doc.CreateElement("shader_assign")
	material_shader_assign.ParentNode.ReplaceChild(shader_assign, material_shader_assign)

	shader_assign.SetAttribute("shader_archive",
		material_shader_assign.GetAttribute("shader_archive"))


	# <shader_assign> の shader_name を shading_model に変更します。
	shader_assign.SetAttribute("shading_model",
		material_shader_assign.GetAttribute("shader_name"))

	shader_option_array = material_shader_assign.SelectSingleNode("shader_option_array")
	if shader_option_array:
		shader_assign.AppendChild(shader_option_array)

	sampler_assign_array = material_shader_assign.SelectSingleNode("sampler_assign_array")
	if sampler_assign_array:
		shader_assign.AppendChild(sampler_assign_array)

		# <sampler_assign> の sampler_index を sampler_name に変更し、インデックスを名前に変換します。
		for sampler_assign in sampler_assign_array.SelectNodes("sampler_assign"):
			sampler_index = int(sampler_assign.GetAttribute("sampler_index")) + 1
			sampler_assign.RemoveAttribute("sampler_index")
			sampler = material.SelectSingleNode("sampler_array/sampler[%d]" % (sampler_index))
			sampler_assign.SetAttribute("sampler_name", sampler.GetAttribute("name"))

	shader_param_array = material_shader_assign.SelectSingleNode("shader_param_array")
	if shader_param_array:
		shader_assign.AppendChild(shader_param_array)

#----------------------------------------------------------
# 頂点の更新
def UpdateVertex(doc, vertex):

	# <input> の quantize_type を <vtx_attrib> に移動します。
	for input in vertex.SelectNodes("vtx_buffer_array/vtx_buffer/input_array/input"):
		quantize_type = input.GetAttribute("quantize_type")
		input.RemoveAttribute("quantize_type")

		attrib_index = int(input.GetAttribute("attrib_index")) + 1
		vtx_attrib = vertex.SelectSingleNode("vtx_attrib_array/vtx_attrib[%d]" % (attrib_index))
		vtx_attrib.SetAttribute("quantize_type", quantize_type)

#----------------------------------------------------------
# シェイプの更新
def UpdateShape(doc, shape, shape_index):

	# <shape_shader_assign> を削除します。
	shape_shader_assign = shape.SelectSingleNode("shape_shader_assign")
	if not shape_shader_assign:
		return
	shape.RemoveChild(shape_shader_assign)

	if not shape_shader_assign.SelectSingleNode("attrib_assign_array"):
		return


	# <attrib_assign> の attrib_index を attrib_name に変更し、インデックスを名前に変換します。
	vertex_index = int(shape.SelectSingleNode("shape_info/@vertex_index").Value) + 1
	vertex = doc.SelectSingleNode("/nw4f_3dif/model/vertex_array/vertex[%d]" % (vertex_index))

	for attrib_assign in shape_shader_assign.SelectNodes("attrib_assign_array/attrib_assign"):
		attrib_index = int(attrib_assign.GetAttribute("attrib_index")) + 1
		attrib_assign.RemoveAttribute("attrib_index")
		attrib_name = vertex.SelectSingleNode(
			"vtx_attrib_array/vtx_attrib[%d]/@name" % (attrib_index)).Value
		attrib_assign.SetAttribute("attrib_name", attrib_name)


	# <attrib_assign> を <shape_shader_assign> から <shader_assign> に移動します。
	renderset = doc.SelectSingleNode(
		"/nw4f_3dif/model/renderset_array/renderset[@shape_index = %d]" % (shape_index))

	material_index = int(renderset.GetAttribute("material_index")) + 1
	shader_assign = doc.SelectSingleNode(
		"/nw4f_3dif/model/material_array/material[%d]/shader_assign" % (material_index))

	# 対象 <material> に <attrib_assign_array> がすでにあれば、そのまま追加する
	attrib_assign_array = shader_assign.SelectSingleNode("attrib_assign_array")
	if not attrib_assign_array:
		attrib_assign_array = doc.CreateElement("attrib_assign_array")
		attrib_assign_array.SetAttribute("length", "1")
		shader_assign.AppendChild(attrib_assign_array)

	for attrib_assign in shape_shader_assign.SelectNodes("attrib_assign_array/attrib_assign"):
		# すでに同じ id を持つ <attrib_assign> があれば、登録しない
		id = attrib_assign.GetAttribute("id")
		exist = attrib_assign_array.SelectSingleNode("attrib_assign[@id = \"%s\"]" % (id))
		if not exist:
			attrib_assign_array.AppendChild(attrib_assign)

#==========================================================
# シェーダコンフィグの更新
def UpdateShaderConfig(doc):

	# <shader_config_info> を code_page="65001" で追加します。
	shader_config_info = doc.CreateElement("shader_config_info")
	shader_config_info.SetAttribute("code_page", "65001")
	shader_config = doc.SelectSingleNode("/nw4f_3dif/shader_config")
	shader_config.PrependChild(shader_config_info)

	# <variation> に default を空文字列で追加します。
	for variation in doc.SelectNodes(
		"/nw4f_3dif/shader_config/shader_array/shader/variation_array/variation"):
		variation.SetAttribute("default", "")

	# <tool_data> と <user_tool_data> を削除します。
	tool_data = doc.SelectSingleNode("/nw4f_3dif/shader_config/tool_data")
	if tool_data:
		tool_data.ParentNode.RemoveChild(tool_data)

	user_tool_data = doc.SelectSingleNode("/nw4f_3dif/shader_config/user_tool_data")
	if user_tool_data:
		user_tool_data.ParentNode.RemoveChild(user_tool_data)

#==========================================================
