﻿#----------------------------------------------------------------------------
# Project:  NintendoWare
#
# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.
#----------------------------------------------------------------------------

# 中間ファイルの更新、System.Xml.XmlDocument 型の doc を更新します
def Update(doc):
	# <nw4f_3dif> version を 0.5.0 に変更
	version = doc.SelectSingleNode("/nw4f_3dif/@version")
	version.Value = "0.5.0"

	# モデルの更新
	if doc.SelectSingleNode("/nw4f_3dif/model"):
		UpdateModel(doc)

	# テクスチャの更新
	if doc.SelectSingleNode("/nw4f_3dif/texture"):
		UpdateTexture(doc)

	# スケルタルアニメの更新
	if doc.SelectSingleNode("/nw4f_3dif/skeletal_anim"):
		UpdateSkeletalAnim(doc)

	# ボーンビジビリティアニメの更新
	if doc.SelectSingleNode("/nw4f_3dif/bone_visibility_anim"):
		UpdateBoneVisibilityAnim(doc)

#==========================================================
# モデルの更新
def UpdateModel(doc):
	material = "/nw4f_3dif/model/material_array/material"

	#------------------------------------------------------
	# <material_info> に pass_name を空文字列で追加します。
	for material_info in doc.SelectNodes(material + "/material_info"):
		material_info.SetAttribute("pass_name", "")

	#------------------------------------------------------
	# <render_state>
	for render_state in doc.SelectNodes(material + "/render_state"):
		mode = render_state.GetAttribute("mode")
		if mode == "custom":
			UpdateRenderStateCustom(doc, render_state)
		elif mode == "opaque":
			UpdateRenderStateOpaque(doc, render_state)
		elif mode == "mask":
			UpdateRenderStateMask(doc, render_state)
		elif mode == "translucent":
			UpdateRenderStateTranslucent(doc, render_state)

	#------------------------------------------------------
	# <material_shader_assign> に shader_archive を空文字列で追加し、
	# key と block_size を削除します。
	for material_shader_assign in doc.SelectNodes(
		material + "/material_shader_assign"):
		material_shader_assign.SetAttribute("shader_archive", "")
		material_shader_assign.RemoveAttribute("key")
		material_shader_assign.RemoveAttribute("block_size")

	#------------------------------------------------------
	# <shader_param> の offset を削除します。
	for shader_param in doc.SelectNodes(
		material + "/material_shader_assign/shader_param_array/shader_param"):
		shader_param.RemoveAttribute("offset")

	#------------------------------------------------------
	# <bone> の render_matrix の名前を rigid_body に変更します。
	for bone in doc.SelectNodes(
		"/nw4f_3dif/model/skeleton/bone_array/bone"):
		render_matrix = bone.GetAttribute("render_matrix")
		bone.RemoveAttribute("render_matrix")
		bone.SetAttribute("rigid_body", render_matrix)

	#------------------------------------------------------
	# <shape_shader_assign> に shader_archive を空文字列で追加し、key を削除します。
	for shape_shader_assign in doc.SelectNodes(
		"/nw4f_3dif/model/shape_array/shape/shape_shader_assign"):
		shape_shader_assign.SetAttribute("shader_archive", "")
		shape_shader_assign.RemoveAttribute("key")

#----------------------------------------------------------
def UpdateRenderStateCustom(doc, render_state):
	blend_control = render_state.SelectSingleNode("blend_control")
	render_state.RemoveChild(blend_control)

	blend_mode = blend_control.GetAttribute("mode")
	if blend_mode == "blend":
		blend_mode = "color"
	render_state.SetAttribute("blend_mode", blend_mode)

	color_blend = blend_control.SelectSingleNode("color_blend")
	if color_blend == None:
		color_blend = CreateColorBlend(doc)
	render_state.AppendChild(color_blend)

	logical_blend = blend_control.SelectSingleNode("logical_blend")
	if logical_blend == None:
		logical_blend = CreateLogicalBlend(doc)
	render_state.AppendChild(logical_blend)

#----------------------------------------------------------
def UpdateRenderStateOpaque(doc, render_state):
	render_state.SetAttribute("blend_mode", "none")

	depth_test = render_state.SelectSingleNode("depth_test")
	if depth_test == None:
		depth_test = doc.CreateElement("depth_test")
		render_state.AppendChild(depth_test)
	depth_test.SetAttribute("enable", "true")
	depth_test.SetAttribute("write", "true")
	depth_test.SetAttribute("func", "lequal")

	alpha_test = render_state.SelectSingleNode("alpha_test")
	if alpha_test == None:
		alpha_test = doc.CreateElement("alpha_test")
		render_state.AppendChild(alpha_test)
		alpha_test.SetAttribute("func", "greater")
		alpha_test.SetAttribute("value", "0.5")
	alpha_test.SetAttribute("enable", "false")

	color_blend = None
	logical_blend = None
	blend_control = render_state.SelectSingleNode("blend_control")
	if blend_control != None:
		render_state.RemoveChild(blend_control)
		color_blend = blend_control.SelectSingleNode("color_blend")
		logical_blend = blend_control.SelectSingleNode("logical_blend")

	if color_blend == None:
		color_blend = CreateColorBlend(doc)
	render_state.AppendChild(color_blend)

	if logical_blend == None:
		logical_blend = CreateLogicalBlend(doc)
	logical_blend.SetAttribute("op", "copy")
	render_state.AppendChild(logical_blend)

#----------------------------------------------------------
def UpdateRenderStateMask(doc, render_state):
	render_state.SetAttribute("blend_mode", "none")

	depth_test = render_state.SelectSingleNode("depth_test")
	if depth_test == None:
		depth_test = doc.CreateElement("depth_test")
		render_state.AppendChild(depth_test)
	depth_test.SetAttribute("enable", "true")
	depth_test.SetAttribute("write", "true")
	depth_test.SetAttribute("func", "lequal")

	alpha_test = render_state.SelectSingleNode("alpha_test")
	if alpha_test == None:
		alpha_test = doc.CreateElement("alpha_test")
		render_state.AppendChild(alpha_test)
		alpha_test.SetAttribute("func", "greater")
		alpha_test.SetAttribute("value", "0.5")
	alpha_test.SetAttribute("enable", "true") # 変更点

	color_blend = None
	logical_blend = None
	blend_control = render_state.SelectSingleNode("blend_control")
	if blend_control != None:
		render_state.RemoveChild(blend_control)
		color_blend = blend_control.SelectSingleNode("color_blend")
		logical_blend = blend_control.SelectSingleNode("logical_blend")

	if color_blend == None:
		color_blend = CreateColorBlend(doc)
	render_state.AppendChild(color_blend)

	if logical_blend == None:
		logical_blend = CreateLogicalBlend(doc)
	logical_blend.SetAttribute("op", "copy")
	render_state.AppendChild(logical_blend)

#----------------------------------------------------------
def UpdateRenderStateTranslucent(doc, render_state):
	render_state.SetAttribute("blend_mode", "color") # 変更点

	depth_test = render_state.SelectSingleNode("depth_test")
	if depth_test == None:
		depth_test = doc.CreateElement("depth_test")
		render_state.AppendChild(depth_test)
	depth_test.SetAttribute("enable", "true")
	depth_test.SetAttribute("write", "false") # 変更点
	depth_test.SetAttribute("func", "lequal")

	alpha_test = render_state.SelectSingleNode("alpha_test")
	if alpha_test == None:
		alpha_test = doc.CreateElement("alpha_test")
		render_state.AppendChild(alpha_test)
		alpha_test.SetAttribute("func", "greater")
		alpha_test.SetAttribute("value", "0.5")
		alpha_test.SetAttribute("enable", "false") # 変更点

	color_blend = None
	logical_blend = None
	blend_control = render_state.SelectSingleNode("blend_control")
	if blend_control != None:
		render_state.RemoveChild(blend_control)
		color_blend = blend_control.SelectSingleNode("color_blend")
		logical_blend = blend_control.SelectSingleNode("logical_blend")

	if color_blend == None:
		color_blend = CreateColorBlend(doc)
	render_state.AppendChild(color_blend)

	if logical_blend == None:
		logical_blend = CreateLogicalBlend(doc)
	logical_blend.SetAttribute("op", "copy")
	render_state.AppendChild(logical_blend)

#----------------------------------------------------------
def CreateColorBlend(doc):
	color_blend = doc.CreateElement("color_blend")
	color_blend.SetAttribute("rgb_src_func", "src_alpha")
	color_blend.SetAttribute("rgb_dst_func", "one_minus_src_alpha")
	color_blend.SetAttribute("rgb_op", "add")
	color_blend.SetAttribute("alpha_src_func", "one")
	color_blend.SetAttribute("alpha_dst_func", "zero")
	color_blend.SetAttribute("alpha_op", "add")
	color_blend.SetAttribute("const_color", "0 0 0 0")
	return color_blend

#----------------------------------------------------------
def CreateLogicalBlend(doc):
	logical_blend = doc.CreateElement("logical_blend")
	logical_blend.SetAttribute("op", "copy")
	return logical_blend

#==========================================================
# テクスチャの更新
def UpdateTexture(doc):

	#------------------------------------------------------
	# <texture_info> の quantize_type を、新しい値に置き換えます。
	for texture_info in doc.SelectNodes("/nw4f_3dif/texture/texture_info"):
		quantize_type = texture_info.GetAttribute("quantize_type")
		if quantize_type == "unorm_6_5_5":
			texture_info.SetAttribute("quantize_type", "unorm_5_5_6")
		elif quantize_type == "snorm_6_5_5":
			texture_info.SetAttribute("quantize_type", "snorm 5_5_6")
		elif quantize_type == "unorm_1_5_5_5":
			texture_info.SetAttribute("quantize_type", "unorm_5_5_5_1")
		elif quantize_type == "unorm_5_5_5_1":
			texture_info.SetAttribute("quantize_type", "unorm_1_5_5_5")
		elif quantize_type == "float_10_11_11":
			texture_info.SetAttribute("quantize_type", "float_11_11_10")
		elif quantize_type == "unorm_2_10_10_10":
			texture_info.SetAttribute("quantize_type", "unorm_10_10_10_2")
		elif quantize_type == "uint_2_10_10_10":
			texture_info.SetAttribute("quantize_type", "uint_10_10_10_2")
		elif quantize_type == "unorm_10_10_10_2":
			texture_info.SetAttribute("quantize_type", "unorm_2_10_10_10")
		elif quantize_type == "uint_10_10_10_2":
			texture_info.SetAttribute("quantize_type", "uint_2_10_10_10")
		elif quantize_type == "sharedexp_5_9_9_9":
			texture_info.SetAttribute("quantize_type", "sharedexp_9_9_9_5")

#==========================================================
# スケルタルアニメの更新
def UpdateSkeletalAnim(doc):

	#------------------------------------------------------
	# <bone_anim> の render_matrix の名前を rigid_body に変更します。
	# <bone_anim> に matrix_index を "-1 -1" で追加します。
	for bone_anim in doc.SelectNodes(
		"/nw4f_3dif/skeletal_anim/bone_anim_array/bone_anim"):
		render_matrix = bone_anim.GetAttribute("render_matrix")
		bone_anim.RemoveAttribute("render_matrix")
		bone_anim.SetAttribute("rigid_body", render_matrix)
		bone_anim.SetAttribute("matrix_index", "-1 -1")

#==========================================================
# ボーンビジビリティアニメの更新
def UpdateBoneVisibilityAnim(doc):

	#------------------------------------------------------
	# <bone_vis_bone_anim> の render_matrix の名前を rigid_body に変更します。
	# <bone_vis_bone_anim> に matrix_index を "-1 -1" で追加します。
	for bone_vis_bone_anim in doc.SelectNodes(
		"/nw4f_3dif/bone_visibility_anim/bone_vis_bone_anim_array/bone_vis_bone_anim"):
		render_matrix = bone_vis_bone_anim.GetAttribute("render_matrix")
		bone_vis_bone_anim.RemoveAttribute("render_matrix")
		bone_vis_bone_anim.SetAttribute("rigid_body", render_matrix)
		bone_vis_bone_anim.SetAttribute("matrix_index", "-1 -1")

#==========================================================
