@echo off
setlocal
color 1F
set maxVersion=2015

echo ---- Setup NintendoExport 3ds Max %maxVersion% Plugins ----

set xcopyNrm=/r /y
set srcFolder=%~dp0
call set destFolder=%%ADSK_3DSMAX_x64_%maxVersion%%%

rem -- check 3dsMax installed
if "%destFolder%" == "" (
	echo --- 3ds Max %maxVersion% is not installed
	pause
	exit /b 1
)

rem -- check runas administorator
for /f "tokens=3 delims=\ " %%i in ('whoami /groups^|find "Mandatory"') do set LEVEL=%%i
if "%LEVEL%" neq "High" (
	echo --- To install the plugins you must have administrator privileges
	cscript "%~dp0\runasadmin.wsf" //Nologo "%~f0"
	exit /b 1
)

rem -- delete old plugin
if exist "%destFolder%\plugins\NW4F_Export.dle" del "%destFolder%\plugins\NW4F_Export.dle"
if exist "%destFolder%\scripts\Startup\NW4F_*.*" del "%destFolder%\scripts\Startup\NW4F_*.*"
if exist "%destFolder%\scripts\Startup\NintendoExport*.*" del "%destFolder%\scripts\Startup\NintendoExport*.*"

xcopy "%srcFolder%plugins-%maxVersion%\NintendoExport.dle" "%destFolder%\plugins\" %xcopyNrm%
xcopy "%srcFolder%scripts\NintendoExport.ms" "%destFolder%\scripts\Startup\" %xcopyNrm%
xcopy "%srcFolder%scripts\NintendoExportMaterialOptions.ms.inc" "%destFolder%\scripts\Startup\" %xcopyNrm%
xcopy "%srcFolder%scripts\NintendoExportNodeOptions.ms.inc" "%destFolder%\scripts\Startup\" %xcopyNrm%
xcopy "%srcFolder%scripts\NintendoExportUtilities.ms.inc" "%destFolder%\scripts\Startup\" %xcopyNrm%
pause
