﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Applet;

namespace nn.vi
{
    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct IndirectLayerHandleType { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct IndirectProducerHandleType { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct IndirectConsumerHandleType { }
}

namespace nn
{
    [ExternalStruct(8, 8)]
    [CppRefPath("<nn/nn_TimeSpan.h>")]
    public struct TimeSpan
    {
    }
}

namespace nn.applet
{
    [CppRefPath("<nn/applet/applet.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }

    [CppRefPath("<nn/applet/applet.h>")]
    [CheckAppletResourceUserId]
    [CppFullName("nn::applet::AppletResourceUserId")]
    [ExternalStruct(8, 8)]
    public struct CheckedAppletResourceUserId
    {
    }
}

namespace nnt.vi
{
    // Method IDs
    // 1000-1999: Indirect Display

    public interface Service : IServiceObject
    {

        // IndirectDisplay
        [MethodId(1000)]
        Result CreateIndirectLayer(int32_t slot);

        [MethodId(1001)]
        Result DestroyIndirectLayer(int32_t slot);

        [MethodId(1010)]
        Result CreateIndirectLayerProducerEndPoint(Out<nn.vi.IndirectProducerHandleType> outHandle, int32_t slot, nn.applet.AppletResourceUserId aruid);

        [MethodId(1011)]
        Result DestroyIndirectLayerProducerEndPoint(int32_t slot);

        [MethodId(1020)]
        Result CreateIndirectLayerConsumerEndPoint(Out<nn.vi.IndirectConsumerHandleType> outHandle, int32_t slot, nn.applet.AppletResourceUserId aruid);

        [MethodId(1021)]
        Result DestroyIndirectLayerConsumerEndPoint(int32_t slot);

        [MethodId(1030)]
        Result SetIndirectLayerProducerFlipOffset(int32_t slot, nn.TimeSpan offset);

    }
}
