﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nnt/vi/testVi_Service.sfdl.h>

namespace nnt{ namespace vi{

    class ServiceImpl
    {
    public:
        ServiceImpl() NN_NOEXCEPT;
        ~ServiceImpl() NN_NOEXCEPT;

        // Indirect Display
        nn::Result CreateIndirectLayer(std::int32_t slot) NN_NOEXCEPT;
        nn::Result DestroyIndirectLayer(std::int32_t slot) NN_NOEXCEPT;
        nn::Result CreateIndirectLayerProducerEndPoint(nn::sf::Out<nn::vi::IndirectProducerHandleType> outHandle, std::int32_t slot, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result DestroyIndirectLayerProducerEndPoint(std::int32_t slot) NN_NOEXCEPT;
        nn::Result CreateIndirectLayerConsumerEndPoint(nn::sf::Out<nn::vi::IndirectConsumerHandleType> outHandle, std::int32_t slot, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result DestroyIndirectLayerConsumerEndPoint(std::int32_t slot) NN_NOEXCEPT;
        nn::Result SetIndirectLayerProducerFlipOffset(std::int32_t slot, nn::TimeSpan offset) NN_NOEXCEPT;
    };

}}
