﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/vi.h>
#include <nvn/nvn.h>
#include <nvn/nvn_FuncPtrInline.h>
#include "MemoryPool.h"
#include "Color.h"

class Window
{
    NN_DISALLOW_COPY(Window);
    NN_DISALLOW_MOVE(Window);
public:
    Window(NVNdevice* pDevice, nn::vi::Layer* pLayer, int width, int height, Color backgroundColor) NN_NOEXCEPT;
    ~Window() NN_NOEXCEPT;

    NVNwindow* GetWindow() const NN_NOEXCEPT;
    NVNtexture* GetTexture(int i) const NN_NOEXCEPT;
    const float* GetBackgroundColorChannels() const NN_NOEXCEPT;

    int GetTextureWidth() const NN_NOEXCEPT;
    int GetTextureHeight() const NN_NOEXCEPT;
private:
    // double buffering
    static const int TextureCount = 2;

    NVNwindow* m_Window;
    NVNtexture* m_Textures[TextureCount];
    MemoryPool m_Pool;

    int m_TextureWidth;
    int m_TextureHeight;
    NVNtextureBuilder m_TextureBuilder;

    Color m_BackgroundColor;

    void InitializeTextureBuilder(NVNdevice* pDevice) NN_NOEXCEPT;
    void InitializeTextures() NN_NOEXCEPT;
};
