﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <vector>
#include "SettingsStub.h"

namespace
{
    class Setting
    {
    public:
        Setting(const void* buffer, size_t bufferSize, const char* key) NN_NOEXCEPT
            : m_Buffer(new char[bufferSize])
            , m_BufferSize(bufferSize)
            , m_Key(key)
        {
            std::memcpy(m_Buffer, buffer, bufferSize);
        }

        Setting(Setting&& rhs) NN_NOEXCEPT
            : m_Buffer(rhs.m_Buffer)
            , m_BufferSize(rhs.m_BufferSize)
            , m_Key(rhs.m_Key)
        {
            rhs.m_Buffer = nullptr;
            rhs.m_BufferSize = 0;
            rhs.m_Key = nullptr;
        }

        ~Setting() NN_NOEXCEPT
        {
            delete [] m_Buffer;
        }

        const char* GetKey() const NN_NOEXCEPT
        {
            return m_Key;
        }

        const void* GetBuffer() const NN_NOEXCEPT
        {
            return m_Buffer;
        }

        size_t GetBufferSize() const NN_NOEXCEPT
        {
            return m_BufferSize;
        }
    private:
        char* m_Buffer;
        size_t m_BufferSize;
        const char* m_Key;
    };

    typedef std::vector<Setting> SettingsList;
    SettingsList g_Settings;
}

namespace nn { namespace settings { namespace fwdbg {
    size_t GetSettingsItemValue(void* buffer, size_t bufferSize, const char* name, const char* key) NN_NOEXCEPT
    {
        NN_UNUSED(name);

        for( const Setting& setting : g_Settings )
        {
            if( std::strcmp(key, setting.GetKey()) == 0 )
            {
                size_t writeSize = std::min(bufferSize, setting.GetBufferSize());
                std::memcpy(buffer, setting.GetBuffer(), std::min(bufferSize, writeSize));
                return writeSize;
            }
        }

        return 0;
    }
}}}

namespace nnt { namespace settings {
    void Initialize() NN_NOEXCEPT
    {
    }

    void Finalize() NN_NOEXCEPT
    {
        g_Settings.clear();
    }

    void Write(const void* buffer, size_t bufferSize, const char* key) NN_NOEXCEPT
    {
        Setting setting(buffer, bufferSize, key);
        g_Settings.push_back(std::move(setting));
    }
}}
