﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nnt/viUtil/testVi_Fixture.h>
#include <nn/vi.h>

typedef nnt::vi::util::Fixture ListDisplays;

TEST_F(ListDisplays, pOutDisplaysNull_Any)
{
    nn::vi::Initialize();

    EXPECT_EQ(0, nn::vi::ListDisplays(nullptr, 1));
}

TEST_F(ListDisplays, ZeroCount_Any)
{
    nn::vi::Initialize();

    nn::vi::DisplayInfo display;
    std::memset(display.name, 0, sizeof(display.name));
    display.hasLayerLimit = false;
    display.layerCountMax = 0;
    display.layerWidthPixelCountMax = 0;
    display.layerHeightPixelCountMax = 0;

    EXPECT_EQ(0, nn::vi::ListDisplays(&display, 0));

    for( int i = 0; i < sizeof(display.name); ++i )
    {
        EXPECT_EQ(0, display.name[i]);
    }

    EXPECT_FALSE(display.hasLayerLimit);
    EXPECT_EQ(0, display.layerCountMax);
    EXPECT_EQ(0, display.layerWidthPixelCountMax);
    EXPECT_EQ(0, display.layerHeightPixelCountMax);
}

TEST(ListDisplaysPreconditions, ViNotInitialized_Any)
{
    nn::vi::DisplayInfo display;
    ASSERT_DEATH_IF_SUPPORTED(nn::vi::ListDisplays(&display, 1), "");
}

TEST(ListDisplaysPreconditions, NegativeCount_Any)
{
    nn::vi::Initialize();

    nn::vi::DisplayInfo display;
    EXPECT_DEATH_IF_SUPPORTED(nn::vi::ListDisplays(&display, -1), "");

    nn::vi::Finalize();
}
