﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <list>
#include <random>
#include <nn/nn_Common.h>

#include "../Common/panel/PanelText.h"
#include "../Common/panel/PanelImage.h"

namespace nnt{ namespace vi{

    class DelayChecker
    {
    public:
        static const int ScreenWidth  = 1280;
        static const int ScreenHeight = 720;
        static const int Width  = 1280;
        static const int Height = 20;
    public:
        DelayChecker() NN_NOEXCEPT
        {
            m_IsActive = false;
            m_Position = 0;
            m_pPanel = std::make_shared<PanelText>();
            m_pPanel->SetTransparent(false);
            m_pPanel->SetColor(nn::util::Color4f(1, 1, 0, 1));
            m_pPanel->SetPosition(nn::util::Vector3f(0, 0, 0));
            m_pPanel->SetSize(nn::util::MakeFloat2(Width, Height));
            m_pPanel->SetVisible(false);
        }

        void Activate() NN_NOEXCEPT
        {
            m_IsActive = true;
            m_Position = -Width;
            m_pPanel->SetVisible(true);
        }

        void Update() NN_NOEXCEPT
        {
            if(!m_IsActive)
            {
                return;
            }

            m_Position++;

            if(m_Position > ScreenWidth)
            {
                m_IsActive = false;
                m_pPanel->SetVisible(false);
            }

            m_pPanel->SetPosition(nn::util::Vector3f(static_cast<float>(m_Position), ScreenHeight - Height, 0));
        }

        std::shared_ptr<PanelText> GetPanel() NN_NOEXCEPT
        {
            return m_pPanel;
        }

    private:
        bool m_IsActive;
        int  m_Position;
        std::shared_ptr<PanelText> m_pPanel;
    };


    struct SquareObject
    {
        nn::util::Vector3f radius;
        nn::util::Vector3f position;
        nn::util::Vector3f velocity;
        std::shared_ptr<PanelText> pPanel;
    };

    class Scene
    {
    public:
        static const int ImageWidth = 1280;
        static const int ImageHeight = 720;

    public:
        Scene() NN_NOEXCEPT;

        void Update() NN_NOEXCEPT;
        void Draw(nn::gfx::CommandBuffer* pCommandBuffer, int resourceLockIndex) NN_NOEXCEPT;

        void AddSquareObject();
        void UpdateAllSquareObjects();

    private:
        int m_FrameCount;
        std::shared_ptr<PanelText> m_pPanelBackGround;
        std::shared_ptr<PanelText> m_pPanelFrameCount;
        std::shared_ptr<PanelImage> m_pPanelIndirectImage;

        int m_PreGetImageWaitMicroSeconds;
        size_t m_RequiredSize;
        size_t m_RequiredAlignment;

        std::mt19937 m_Random;
        std::list<SquareObject> m_SquareObjectList;

        std::shared_ptr<DelayChecker> m_pDelayChecker;
    };

}}
