﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>

#include <nn/nn_Common.h>
#include "IPanel.h"
#include "PanelBase.h"

#include "../framework/TextWriterPool.h"

class PanelText
    : public PanelBase<IPanel>
    , public std::enable_shared_from_this<PanelText>
{
public:
    PanelText() NN_NOEXCEPT;

    void SetTextPosition(float x, float y) NN_NOEXCEPT;
    void SetTextSize(float size) NN_NOEXCEPT;
    void SetTextColor(const nn::util::Color4f& color) NN_NOEXCEPT;
    void SetText(const std::string& string) NN_NOEXCEPT;

    // 表示する内容を更新する。
    void Update() NN_NOEXCEPT;
    // 指定したテキストに更新する。
    // SetText() と Update() を連続で呼び出すのと同じ。
    void ChangeText(const std::string& string) NN_NOEXCEPT;

    void SetTextWriter(const std::shared_ptr<framework::PoolTextWriterHolder>& value) NN_NOEXCEPT;
    std::shared_ptr<framework::PoolTextWriterHolder> GetTextWriter() NN_NOEXCEPT;

    PANEL_CAST_FUNCTION(Text);

private:
    std::shared_ptr<framework::PoolTextWriterHolder> m_TextWriter;

    std::string m_Text;
    float m_TextPositionX;
    float m_TextPositionY;
    float m_TextSize;
    nn::util::Color4f m_TextColor;
};

