﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "../framework/Rectangle.h"
#include "../framework/TexturePool.h"
#include "IPanel.h"
#include "PanelContainer.h"
#include "PanelImage.h"
#include "PanelText.h"


class PanelRenderer
{
private:
    struct RenderContext
    {
        framework::Rectangle cropRect;
        bool isRegisterRegionRequired;
        int resourceLockIndex;
    };
public:
    static void Initialize() NN_NOEXCEPT;
    static void Finalize() NN_NOEXCEPT;

    static void Render(
        nn::gfx::CommandBuffer* pCommandBuffer,
        const std::shared_ptr<IPanel>& panel,
        const framework::Rectangle& cropRect,
        int resourceLockIndex
    ) NN_NOEXCEPT;

private:
    static void RenderImpl(
        nn::gfx::CommandBuffer* pCommandBuffer,
        const std::shared_ptr<IPanel>& panel,
        const RenderContext& ctxt
    ) NN_NOEXCEPT;

private:
    static void RenderMisc(
        nn::gfx::CommandBuffer* pCommandBuffer,
        const std::shared_ptr<IPanel>& panel,
        const RenderContext& ctxt
    ) NN_NOEXCEPT;

    static void RenderContainer(
        nn::gfx::CommandBuffer* pCommandBuffer,
        const std::shared_ptr<PanelContainer>& panel,
        const RenderContext& ctxt
    ) NN_NOEXCEPT;

    static void RenderImage(
        nn::gfx::CommandBuffer* pCommandBuffer,
        const std::shared_ptr<PanelImage>& panel,
        const RenderContext& ctxt
    ) NN_NOEXCEPT;

    static void RenderText(
        nn::gfx::CommandBuffer* pCommandBuffer,
        const std::shared_ptr<PanelText>& panel,
        const RenderContext& ctxt
    ) NN_NOEXCEPT;

private:
    // Draw 系一般
    // @return 描画が発生した場合 true を返します。
    static bool DrawSolid(
        nn::gfx::CommandBuffer* pCommandBuffer,
        const std::shared_ptr<IPanel>& panel,
        const RenderContext& ctxt
    ) NN_NOEXCEPT;

private:
    static bool DrawImplClearColor(
        nn::gfx::CommandBuffer* pCommandBuffer,
        const std::shared_ptr<IPanel>& panel,
        const RenderContext& ctxt
    ) NN_NOEXCEPT;

    static bool DrawImplShader(
        nn::gfx::CommandBuffer* pCommandBuffer,
        const std::shared_ptr<IPanel>& panel,
        const std::shared_ptr<framework::PoolTexture>& texture,
        const RenderContext& ctxt
    ) NN_NOEXCEPT;

    static bool DrawImplTextWriter(
        nn::gfx::CommandBuffer* pCommandBuffer,
        const std::shared_ptr<IPanel>& panel,
        const std::shared_ptr<framework::PoolTextWriterHolder>& textWriter,
        const RenderContext& ctxt
    ) NN_NOEXCEPT;

};
