﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "PanelImagePreparationTask.h"

#include <nn/gfx/util/gfx_ObjectHolder.h>
#include "../framework/Framework.h"
#include "../framework/TexturePool.h"

#include <nvn/nvn_FuncPtrInline.h>

namespace panel{

    namespace {
        struct PrepareImageState
        {
        public:
            PrepareImageState() NN_NOEXCEPT
            {
            }

            ~PrepareImageState() NN_NOEXCEPT
            {
            }

        public:
            std::shared_ptr<framework::PoolTexture> pTexture;
            std::shared_ptr<ImageTransferBuffer> pBuffer;
        };
    }


    PanelImagePreparationTask::PanelImagePreparationTask(
        const std::shared_ptr<PanelImage>& pPanel,
        const std::shared_ptr<ImageTransferBuffer>& pBuffer
    ) NN_NOEXCEPT
        : m_pPanel(pPanel)
        , m_pBuffer(pBuffer)
    {
    }

    PanelPreparationResult PanelImagePreparationTask::Prepare(nn::gfx::CommandBuffer* pCommandBuffer, int resourceLockIndex) NN_NOEXCEPT
    {
        NN_UNUSED(pCommandBuffer);
        auto p = m_pPanel.lock();
        if(!p)
        {
            return PanelPreparationResult_Canceled;
        }
        auto pBuffer = m_pBuffer.lock();
        if(!pBuffer)
        {
            return PanelPreparationResult_Canceled;
        }

        int width = pBuffer->GetWidth();
        int height = pBuffer->GetHeight();

        // Texture を取得
        auto pTexture = Framework::AcquirePoolTexture(width, height, pBuffer->GetFormat());
        if(!pTexture)
        {
            return PanelPreparationResult_NeedRetry;
        }


        nn::gfx::BufferTextureCopyRegion region;
        region.SetDefault();
        region.SetBufferOffset(0);
        region.SetBufferImageWidth(width);
        region.SetBufferImageHeight(height);
        auto& regTexture = region.EditTextureCopyRegion();
        regTexture.SetOffsetU(pTexture->GetOriginX());
        regTexture.SetOffsetV(pTexture->GetOriginY());
        regTexture.SetWidth(width);
        regTexture.SetHeight(height);
        pCommandBuffer->CopyBufferToImage(pTexture->Get(), pBuffer->Get(), region);

        p->SetTexture(pTexture);

        auto pState = std::make_shared<PrepareImageState>();
        pState->pTexture = pTexture;
        pState->pBuffer  = pBuffer;
        Framework::LockFrameCommandResource(resourceLockIndex, pState);

        // TORIAEZU:
        if(p->GetTransferBuffer() == pBuffer)
        {
            p->SetTransferBuffer(nullptr);
        }

        return PanelPreparationResult_Success;
    }

}
