﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/gfx.h>

namespace panel
{
    enum PanelPreparationResult
    {
        PanelPreparationResult_Success,
        PanelPreparationResult_Failure,
        PanelPreparationResult_Canceled,
        PanelPreparationResult_NeedRetry,
    };

    class IPanelPreparationTask
    {
    public:
        virtual ~IPanelPreparationTask() NN_NOEXCEPT
        {
        }

        virtual PanelPreparationResult Prepare(nn::gfx::CommandBuffer* pCommandBuffer, int resourceLockIndex) NN_NOEXCEPT = 0;
    };
}
