﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/util/util_Matrix.h>
#include <nn/util/util_Color.h>
#include "PanelType.h"
#include "../framework/Rectangle.h"

#define PANEL_CAST_FUNCTION(PanelType)   \
    static std::shared_ptr<Panel##PanelType> Is##PanelType(std::shared_ptr<IPanel> value) NN_NOEXCEPT   \
    {                                                   \
        if(value->GetType() == PanelType_##PanelType)   \
        {                                               \
            return std::static_pointer_cast<Panel##PanelType>(value);   \
        }                                               \
        else                                            \
        {                                               \
            return nullptr;                             \
        }                                               \
    }

class PanelContainer;

class IPanel
{
public:
    virtual ~IPanel() NN_NOEXCEPT
    {
    }

    virtual PanelTypeType GetType() const NN_NOEXCEPT =0;
    virtual nn::util::Vector3f GetPosition() const NN_NOEXCEPT =0;
    virtual nn::util::Float2 GetSize() const NN_NOEXCEPT =0;
    virtual nn::util::Color4f GetColor() const NN_NOEXCEPT =0;
    virtual bool IsVisible() const NN_NOEXCEPT =0;
    virtual bool IsTransparent() const NN_NOEXCEPT =0;

    virtual bool GetFlipYEnabled() const NN_NOEXCEPT =0;

    virtual nn::util::Vector3f GetGlobalPosition() const NN_NOEXCEPT =0;
    virtual framework::Rectangle GetGlobalRectangle() const NN_NOEXCEPT =0;

protected:
    friend class PanelContainer;
    virtual std::shared_ptr<IPanel> GetParent() const NN_NOEXCEPT =0;
    virtual void SetParent(const std::shared_ptr<IPanel>& value) NN_NOEXCEPT =0;
};
