﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "CommandResourceLock.h"
#include "../../Config.h"

namespace framework{ namespace detail{

    void CommandResourceLock::Initialize(int bufferCount) NN_NOEXCEPT
    {
        NNT_VI_FW_REQUIRES_GREATER(bufferCount, 0);
        m_ResourceListList.resize(bufferCount);
    }

    void CommandResourceLock::Finalize() NN_NOEXCEPT
    {
        for(size_t i = 0; i < m_ResourceListList.size(); i++)
        {
            Release(static_cast<int>(i));
        }
    }

    void CommandResourceLock::Lock(int index, const std::shared_ptr<void>& p) NN_NOEXCEPT
    {
        if(!p)
        {
            return;
        }

        m_ResourceListList[index].push_back(p);
    }

    void CommandResourceLock::Release(int index) NN_NOEXCEPT
    {
        NNT_VI_FW_REQUIRES_RANGE(index, 0, static_cast<int>(m_ResourceListList.size()));

        auto& list = m_ResourceListList[index];
        for(auto it = list.rbegin(); it != list.rend(); ++it)
        {
            it->reset();
        }
        list.clear();
    }

}}
