﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <memory>

#include <nn/nn_Common.h>

#include "gfx_GraphicsFramework.h"

#include "TexturePool.h"
#include "TextWriterPool.h"
#include "detail/CommandResourceLock.h"
#include "detail/MemoryPoolManager.h"
#include "FrameworkParameter.h"
#include "Rectangle.h"

namespace framework{

    struct RenderRegion
    {
        nn::util::Color4f clearColor;
        std::vector<Rectangle> regionList;
    };

    struct FrameworkImpl
    {
        FrameworkParameter parameter;
        int frameCount;
        int frameIndex;
        detail::CommandResourceLock commandResourceLock;
        std::vector<RenderRegion> renderedRegion;

        detail::MemoryPoolManager memoryPoolManager;

        TexturePool    texturePool;
        TextWriterPool textWriterPool;

        size_t rootCommandMemoryUsedSizeMax;
        size_t rootControlMemoryUsedSizeMax;
    };

    extern FrameworkImpl g_Impl;
    extern nns::gfx::GraphicsFramework g_Gfw;
}

