﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

in int gl_VertexID;

out gl_PerVertex
{
    vec4 gl_Position;
};
out vec2 vTexCoord;

layout(location = 0) uniform VertexConstants
{
    //vec4 iPosition;
    vec4 iTexRegion;
    //vec2 iSize;
    int iIsFlipYEnabled;
};

void main()
{
    float xLow = iTexRegion.x;
    float yLow = iTexRegion.y;
    float xHigh = iTexRegion.x + iTexRegion.z;
    float yHigh = iTexRegion.y + iTexRegion.w;
    if(iIsFlipYEnabled != 0)
    {
        float tmp = yLow;
        yLow = yHigh;
        yHigh = tmp;
    }

    if(gl_VertexID == 0)
    {
        gl_Position = vec4(-1, -1, 0, 1);
        vTexCoord   = vec2(xLow, yHigh);
    }
    else if(gl_VertexID == 1)
    {
        gl_Position = vec4(+1, -1, 0, 1);
        vTexCoord   = vec2(xHigh, yHigh);
    }
    else if(gl_VertexID == 2)
    {
        gl_Position = vec4(-1, +1, 0, 1);
        vTexCoord   = vec2(xLow, yLow);
    }
    else
    {
        gl_Position = vec4(+1, +1, 0, 1);
        vTexCoord   = vec2(xHigh, yLow);
    }
}
