﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/edid.h>

#define EDID_DEATH_TEST(statement) EXPECT_DEATH_IF_SUPPORTED({ statement; }, ".*")

static bool AudioFormatVisitor(const nn::edid::AudioFormatInfo* pFormat, void* pUserData) NN_NOEXCEPT
{
    NN_UNUSED(pFormat);
    NN_UNUSED(pUserData);

    return false;
}

static bool DisplayModeVisitor(const nn::edid::DisplayModeInfo* pMode,
                               const nn::edid::DisplayTimingInfo* pTimingInfo,
                               const nn::edid::ImageSizeInfo* pSizeInfo,
                               void* pUserData) NN_NOEXCEPT
{
    NN_UNUSED(pMode);
    NN_UNUSED(pTimingInfo);
    NN_UNUSED(pSizeInfo);
    NN_UNUSED(pUserData);

    return false;
}

TEST(Preconditions, VisitAudioFormats)
{
    EDID_DEATH_TEST(nn::edid::VisitAudioFormats(nullptr, AudioFormatVisitor, nullptr));

    EDID_DEATH_TEST
    (
        nn::edid::Edid edid;

        edid._data = nullptr;
        edid._size = 0;

        nn::edid::VisitAudioFormats(&edid, nullptr, nullptr);
    );
}

TEST(Preconditions, GetAudioFormatBitrateMax)
{
    EDID_DEATH_TEST
    (
        nn::edid::AudioFormatInfo format;
        nn::edid::GetAudioFormatBitRateMax(nullptr, &format);
    );

    EDID_DEATH_TEST
    (
        int bitRate;
        nn::edid::GetAudioFormatBitRateMax(&bitRate, nullptr);
    );
}

TEST(Preconditions, GetAudioFormatBitDepth)
{
    EDID_DEATH_TEST
    (
        nn::edid::AudioFormatInfo format;
        nn::edid::GetAudioFormatBitDepth(nullptr, &format);
    );

    EDID_DEATH_TEST
    (
        int bitDepth;
        nn::edid::GetAudioFormatBitDepth(&bitDepth, nullptr);
    );
}

TEST(Preconditions, GetSpeakerAllocation)
{
    EDID_DEATH_TEST(nn::edid::GetSpeakerAllocation(nullptr));
}

TEST(Preconditions, IsAudioSupported)
{
    EDID_DEATH_TEST(nn::edid::IsAudioSupported(nullptr));
}

TEST(Preconditions, GetDisplayInfo)
{
    EDID_DEATH_TEST
    (
        nn::edid::Edid edid;

        edid._data = nullptr;
        edid._size = 0;

        nn::edid::GetDisplayInfo(nullptr, &edid);
    );

    EDID_DEATH_TEST
    (
        nn::edid::DisplayInfo display;
        nn::edid::GetDisplayInfo(&display, nullptr);
    );
}

TEST(Preconditions, GetDisplayWeekOfManufacture)
{
    EDID_DEATH_TEST
    (
        nn::edid::DisplayInfo display;
        nn::edid::GetDisplayWeekOfManufacture(nullptr, &display);
    );

    EDID_DEATH_TEST
    (
        int week;
        nn::edid::GetDisplayWeekOfManufacture(&week, nullptr);
    );
}

TEST(Preconditions, GetDisplayYearOfManufacture)
{
    EDID_DEATH_TEST
    (
        nn::edid::DisplayInfo display;
        nn::edid::GetDisplayYearOfManufacture(nullptr, &display);
    );

    EDID_DEATH_TEST
    (
        int year;
        nn::edid::GetDisplayYearOfManufacture(&year, nullptr);
    );
}

TEST(Preconditions, GetSourcePhysicalAddress)
{
    EDID_DEATH_TEST
    (
        nn::edid::Edid edid;

        edid._data = nullptr;
        edid._size = 0;

        nn::edid::GetSourcePhysicalAddress(nullptr, &edid);
    );

    EDID_DEATH_TEST
    (
        std::uint16_t address;
        nn::edid::GetSourcePhysicalAddress(&address, nullptr);
    );
}

TEST(Preconditions, VisitDisplayModes)
{
    EDID_DEATH_TEST(nn::edid::VisitDisplayModes(nullptr, DisplayModeVisitor, nullptr));

    EDID_DEATH_TEST
    (
        nn::edid::Edid edid;

        edid._data = nullptr;
        edid._size = 0;

        nn::edid::VisitDisplayModes(&edid, nullptr, nullptr);
    );
}

TEST(Preconditions, GetDisplayModePreference)
{
    EDID_DEATH_TEST
    (
        nn::edid::DisplayTimingInfo timing;
        nn::edid::ImageSizeInfo image;

        nn::edid::Edid edid;

        edid._data = nullptr;
        edid._size = 0;

        nn::edid::GetDisplayModePreference(nullptr, &timing, &image, &edid);
    );

    EDID_DEATH_TEST
    (
        nn::edid::DisplayModeInfo display;
        nn::edid::ImageSizeInfo image;

        nn::edid::Edid edid;

        edid._data = nullptr;
        edid._size = 0;

        nn::edid::GetDisplayModePreference(&display, nullptr, &image, &edid);
    );

    EDID_DEATH_TEST
    (
        nn::edid::DisplayModeInfo display;
        nn::edid::DisplayTimingInfo timing;

        nn::edid::Edid edid;

        edid._data = nullptr;
        edid._size = 0;

        nn::edid::GetDisplayModePreference(&display, &timing, nullptr, &edid);
    );

    EDID_DEATH_TEST
    (
        nn::edid::DisplayModeInfo display;
        nn::edid::DisplayTimingInfo timing;
        nn::edid::ImageSizeInfo image;

        nn::edid::GetDisplayModePreference(&display, &timing, &image, nullptr);
    );
}

TEST(Preconditions, OpenEdid)
{
    EDID_DEATH_TEST
    (
        int temp = 0;
        nn::edid::OpenEdid(nullptr, &temp, sizeof(temp));
    );

    EDID_DEATH_TEST
    (
        nn::edid::Edid edid;
        nn::edid::OpenEdid(&edid, nullptr, 0);
    );
}

TEST(Preconditions, CloseEdid)
{
    EDID_DEATH_TEST(nn::edid::CloseEdid(nullptr));
}

TEST(Preconditions, PrintEdid)
{
    EDID_DEATH_TEST(nn::edid::PrintEdid(nullptr));
}
