﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdlib>

#include <nn/os.h>
#include <nn/init.h>

#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nn/socket/socket_Api.h>
#include <nn/socket/socket_Types.h>
#include <nn/nn_Assert.h>


#include <nnt.h>

extern "C"
{
int test500(const char* URL);
int test501(const char* URL);
int test502(const char* URL);
int test503(const char* URL);
int test504(const char* URL);
int test505(const char* URL);
int test506(const char* URL);
int test507(const char* URL);
int test508(const char* URL);
int test509(const char* URL);
int test510(const char* URL);
int test511(const char* URL);
int test512(const char* URL);
int test513(const char* URL);
int test514(const char* URL);
int test515(const char* URL);
int test516(const char* URL);
int test517(const char* URL);
int test518(const char* URL);
int test519(const char* URL);
int test520(const char* URL);
int test521(const char* URL);
int test523(const char* URL);
int test524(const char* URL);
int test525(const char* URL);
int test526(const char* URL);
int test530(const char* URL);
int test533(const char* URL);
int test536(const char* URL);
int test537(const char* URL);
int test537(const char* URL);
int test539(const char* URL);
int test540(const char* URL);
int test541(const char* URL);
int test542(const char* URL);
int test543(const char* URL);
int test544(const char* URL);
int test547(const char* URL);
int test549(const char* URL);
int test552(const char* URL);
int test553(const char* URL);
int test554(const char* URL);
int test555(const char* URL);
int test556(const char* URL);
int test557(const char* URL);
int test558(const char* URL);
int test560(const char* URL);
int test562(const char* URL);
int test564(const char* URL);
int test566(const char* URL);
int test567(const char* URL);
int test568(const char* URL);
int test569(const char* URL);
int test570(const char* URL);
int test571(const char* URL);
int test572(const char* URL);
int test573(const char* URL);
int test574(const char* URL);
int test575(const char* URL);
int test576(const char* URL);
int test578(const char* URL);
int test579(const char* URL);
int test582(const char* URL);
int test583(const char* URL);
int test586(const char* URL);
int test590(const char* URL);
int test591(const char* URL);
int test597(const char* URL);
int test598(const char* URL);
int test599(const char* URL);
int test1500(const char* URL);
int test1501(const char* URL);
int test1502(const char* URL);
int test1506(const char* URL);
int test1507(const char* URL);
int test1508(const char* URL);
int test1509(const char* URL);
int test1510(const char* URL);
int test1511(const char* URL);
int test1512(const char* URL);
int test1513(const char* URL);
int test1514(const char* URL);
int test1515(const char* URL);
int test1520(const char* URL);
int test1525(const char* URL);
int test1526(const char* URL);
int test1527(const char* URL);
int test1528(const char* URL);
int test1529(const char* URL);
int test1900(const char* URL);

int unittest1300(char* arg);
int unittest1301(char* arg);
int unittest1302(char* arg);
int unittest1303(char* arg);
int unittest1304(char* arg);
int unittest1305(char* arg);
int unittest1307(char* arg);
int unittest1308(char* arg);
int unittest1309(char* arg);
int unittest1330(char* arg);
//int unittest1394(char* arg);
int unittest1395(char* arg);
int unittest1396(char* arg);
int unittest1397(char* arg);
int unittest1398(char* arg);
int unittest1600(char* arg);
int unittest1601(char* arg);
int unitfail = 0;
};

namespace
{
    nn::socket::ConfigDefaultWithMemory g_SocketConfigWithMemory;
}

namespace nnt
{
    namespace curl
    {
        const char* s_url = "http://www.example.com";
        //const char* s_url = "http://www.routerlogin.net";
        TEST(Curl, libtest500)
        {
            test500(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest501)
        {
            test501(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest502)
        {
            test502(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest503)
        {
            test503(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest504)
        {
            test504(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest505)
        {
            test505(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest506)
        {
            //TODO: test uses C file-io
            ADD_FAILURE();
            //test506(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest507)
        {
            test507(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest508)
        {
            test508(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest509)
        {
            test509(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest510)
        {
            test510(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest511)
        {
            test511(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest512)
        {
            test512(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest513)
        {
            test513(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest514)
        {
            test514(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest515)
        {
            test515(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest516)
        {
            test516(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest517)
        {
            //TODO: the date printing to va-args ends up resulting in a segmentation fault in VPrintfImplBase::GetStringPrintLength<char>
            ADD_FAILURE();
            //test517(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest518)
        {
            test518(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest519)
        {
            test519(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest520)
        {
            test520(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest521)
        {
            //TODO: This test fails because the second argument is NULL causing a SIGSEV in strtol
            ADD_FAILURE();
            //test521(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest523)
        {
            //TODO: This test uses a proxy server, which is not installed by the unit tests, and so it times out.
            ADD_FAILURE();
            //test523(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest524)
        {
            //TODO: This test uses a proxy server, which is not installed by the unit tests, and so it times out.
            ADD_FAILURE();
            //test524(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest525)
        {
            test525(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest526)
        {
            test526(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest530)
        {
            //FIXME: Curl_list_remove SIGSEV in curl_multi_cleanup? This is probably a real bug.
            ADD_FAILURE();
            //test530(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest533)
        {
            //FIXME: Curl_list_remove SIGSEV in curl_multi_cleanup? This is probably a real bug.
            ADD_FAILURE();
            //test533(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest536)
        {
            //FIXME: Test uses file I/O
            ADD_FAILURE();
            //test536(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest537)
        {
            test537(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest539)
        {
            test539(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest540)
        {
            test540(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest541)
        {
            test541(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest542)
        {
            test542(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest543)
        {
            test543(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest544)
        {
            test544(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest547)
        {
            test547(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest549)
        {
            test549(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest552)
        {
            //FIXME: Test uses file I/O
            ADD_FAILURE();
            //test552(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest553)
        {
            test553(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest554)
        {
            //FIXME: Test uses file I/O
            ADD_FAILURE();
            //test554(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest555)
        {
            test555(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest556)
        {
            test556(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest557)
        {
            test557(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest558)
        {
            test558(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest560)
        {
            test560(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest562)
        {
            //TODO: This test fails because the second argument is NULL causing a SIGSEV in strtol
            ADD_FAILURE();
            //test562(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest564)
        {
            test564(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest566)
        {
            //TODO: test uses C file-io
            ADD_FAILURE();
            //test566(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest567)
        {
            test567(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest568)
        {
            //TODO: test uses C file-io
            ADD_FAILURE();
            //test568(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest569)
        {
            //TODO: test uses C file-io
            ADD_FAILURE();
            //test569(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest570)
        {
            test570(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest571)
        {
            //TODO: test uses C file-io
            ADD_FAILURE();
            //test571(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest572)
        {
            //TODO: test uses C file-io
            ADD_FAILURE();
            //test572(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest573)
        {
            //TODO: test uses C file-io
            ADD_FAILURE();
            test573(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest574)
        {
            //TODO: test spins forever, this is probably a bug
            ADD_FAILURE();
            //test574(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest575)
        {
            //TODO: test spins forever, this is probably a bug
            ADD_FAILURE();
            //test575(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest576)
        {
            //TODO: test spins forever, this is probably a bug
            ADD_FAILURE();
            //test576(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest578)
        {
            //FIXME: Test uses file I/O
            ADD_FAILURE();
            //test578(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest579)
        {
            //FIXME: Test uses file I/O
            ADD_FAILURE();
            //test579(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest582)
        {
            test582(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest583)
        {
            test583(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest586)
        {
            //TODO: the date printing to va-args ends up resulting in a segmentation fault in VPrintfImplBase::GetStringPrintLength<char>
            ADD_FAILURE();
            //test586(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest590)
        {
            test590(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest591)
        {
            //TODO: test uses C file-io
            ADD_FAILURE();
            //test591(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest597)
        {
            test597(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest598)
        {
            test598(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest599)
        {
            //TODO: test uses C file-io
            ADD_FAILURE();
            //test599(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1500)
        {
            test1500(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1501)
        {
            test1501(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1502)
        {
            test1502(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1506)
        {
            //FIXME: Curl_list_remove SIGSEV in curl_multi_cleanup? This is probably a real bug.
            ADD_FAILURE();
            //test1506(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1507)
        {
            //TODO: test uses C file-io
            ADD_FAILURE();
            //test1507(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1508)
        {
            test1508(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1509)
        {
            //TODO: test uses C file-io
            ADD_FAILURE();
            //test1509(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1510)
        {
            test1510(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1511)
        {
            test1511(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1512)
        {
            test1512(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1513)
        {
            test1513(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1514)
        {
            test1514(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1515)
        {
            test1515(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1520)
        {
            test1520(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1525)
        {
            //TODO: test uses C file-io
            ADD_FAILURE();
            //test1525(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1526)
        {
            //TODO: test uses C file-io
            ADD_FAILURE();
            //test1526(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1527)
        {
            //TODO: test uses C file-io
            ADD_FAILURE();
            //test1527(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1528)
        {
            test1528(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1529)
        {
            test1529(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, libtest1900)
        {
            //TODO: test uses C file-io
            ADD_FAILURE();
            //test1900(s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1300)
        {
            unittest1300((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1301)
        {
            unittest1301((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1302)
        {
            unittest1302((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1303)
        {
            unittest1303((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1304)
        {
            //TODO: test uses C file-io
            ADD_FAILURE();
            //unittest1304((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1305)
        {
            unittest1305((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1307)
        {
            unittest1307((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1308)
        {
            //TODO: this test wanders into AddFormDataf --> curl_mvsnprintf and crashes into dprintf_formatf; variable args bug?
            ADD_FAILURE();
            //unittest1308((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1309)
        {
            unittest1309((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1330)
        {
            unittest1330((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1394)
        {
            //TODO: fix parse_cert_getparameter
            ADD_FAILURE();
            //unittest1394((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1395)
        {
            unittest1395((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1396)
        {
            unittest1396((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1397)
        {
            unittest1397((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1398)
        {
            unittest1398((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1600)
        {
            unittest1600((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

        TEST(Curl, unittest1601)
        {
            unittest1601((char*)s_url) == 0 ? SUCCEED() : ADD_FAILURE();
        }

    } //curl
} //nnt



extern "C" void nninitStartup()
{    // メモリヒープの全体サイズを設定する
    const size_t MemoryHeapSize = 16 * 1024 * 1024;
    auto result = nn::os::SetMemoryHeapSize( MemoryHeapSize + nn::socket::DefaultSocketMemoryPoolSize );

    NN_ASSERT( result.IsSuccess() );

    // メモリヒープから malloc で使用するメモリ領域を確保
    uintptr_t address = 0;

    result = nn::os::AllocateMemoryBlock( &address, MemoryHeapSize );
    NN_ASSERT( result.IsSuccess() );

    // malloc 用のメモリ領域を設定する
    nn::init::InitializeAllocator( reinterpret_cast<void*>(address), MemoryHeapSize );
}


//---------------------------------------------------------------------------
//  Test Main 関数
//---------------------------------------------------------------------------

extern "C"
void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char **argv = nnt::GetHostArgv();

    nn::socket::Initialize(g_SocketConfigWithMemory);

    // GoogleTest おまじない
    ::testing::InitGoogleTest(&argc, argv);
    int result = RUN_ALL_TESTS();

    // テスト終了
    NN_LOG("\n=== End Test of curl test\n");

    nnt::Exit(result);
}

