﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testFixtures.h"
#include "utils.h"

CURLcode sslCtxCallback(CURL *curl, void *ssl_ctx, void *userptr)
{
    nn::ssl::Context *ctx = reinterpret_cast<nn::ssl::Context*>(ssl_ctx);
    nn::Result nResult = ctx->Create(nn::ssl::Context::SslVersion_Auto);
    if (nResult.IsFailure())
    {
        return CURLE_SSL_ENGINE_INITFAILED;
    }

    nResult = LoadCaCertIntoContext(ctx);
    if (nResult.IsFailure())
    {
        return CURLE_SSL_CERTPROBLEM;
    }

    return CURLE_OK;
}

TEST_F(CurlTest, HttpsContextCallbackTest)
{
    CURLcode cResult;
    nn::Result nResult;

    const char *testUrl = "https://natf.com/headers.php";

    nn::fs::FileHandle outputFile;
    const char *outputFileName = "sd:/response_https.xml";
    nResult = CreateFileForWriting(&outputFile, outputFileName);
    ASSERT_TRUE(nResult.IsSuccess());

    FileWriterInfo fwInfo;
    fwInfo.handle = outputFile;
    fwInfo.bytesWritten = 0;

    cResult = curl_easy_setopt(cHandle, CURLOPT_SSL_CTX_FUNCTION, sslCtxCallback);
    ASSERT_EQ(CURLE_OK, cResult);

    cResult = curl_easy_setopt(cHandle, CURLOPT_WRITEDATA, &fwInfo);
    ASSERT_EQ(CURLE_OK, cResult);

    cResult = curl_easy_setopt(cHandle, CURLOPT_WRITEFUNCTION, FileWriterCallback);
    ASSERT_EQ(CURLE_OK, cResult);

    cResult = curl_easy_setopt(cHandle, CURLOPT_URL, testUrl);
    ASSERT_EQ(CURLE_OK, cResult);

    cResult = curl_easy_perform(cHandle);
    ASSERT_EQ(CURLE_OK, cResult);

    long responseCode;
    cResult = curl_easy_getinfo(cHandle, CURLINFO_RESPONSE_CODE, &responseCode);
    ASSERT_EQ(CURLE_OK, cResult);
    ASSERT_EQ(200, responseCode);

    nn::fs::CloseFile(outputFile);
}

TEST_F(CurlTest, BasicHttpsTest)
{
    CURLcode cResult;
    nn::Result nResult;

    const char *testUrl = "https://natf.com/headers.php";

    nn::fs::FileHandle outputFile;
    const char *outputFileName = "sd:/response_https.xml";
    nResult = CreateFileForWriting(&outputFile, outputFileName);
    ASSERT_TRUE(nResult.IsSuccess());

    FileWriterInfo fwInfo;
    fwInfo.handle = outputFile;
    fwInfo.bytesWritten = 0;

    nn::ssl::Context sslCtx;
    nResult = sslCtx.Create(nn::ssl::Context::SslVersion_Auto);
    ASSERT_TRUE(nResult.IsSuccess());

    nResult = LoadCaCertIntoContext(&sslCtx);
    ASSERT_TRUE(nResult.IsSuccess());

    cResult = curl_easy_setopt(cHandle, CURLOPT_SSL_CONTEXT, &sslCtx);
    ASSERT_EQ(CURLE_OK, cResult);

    cResult = curl_easy_setopt(cHandle, CURLOPT_WRITEDATA, &fwInfo);
    ASSERT_EQ(CURLE_OK, cResult);

    cResult = curl_easy_setopt(cHandle, CURLOPT_WRITEFUNCTION, FileWriterCallback);
    ASSERT_EQ(CURLE_OK, cResult);

    cResult = curl_easy_setopt(cHandle, CURLOPT_FORBID_REUSE, 1);
    ASSERT_EQ(CURLE_OK, cResult);

    cResult = curl_easy_setopt(cHandle, CURLOPT_URL, testUrl);
    ASSERT_EQ(CURLE_OK, cResult);

    cResult = curl_easy_perform(cHandle);
    ASSERT_EQ(CURLE_OK, cResult);

    long responseCode;
    cResult = curl_easy_getinfo(cHandle, CURLINFO_RESPONSE_CODE, &responseCode);
    ASSERT_EQ(CURLE_OK, cResult);
    ASSERT_EQ(200, responseCode);

    nn::fs::CloseFile(outputFile);

    nResult = sslCtx.Destroy();
    ASSERT_TRUE(nResult.IsSuccess());
}
