﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ReadyModeTestTask.h"

//============================================================
void ReadyModeTestTask::DoInitializeCore()
{
    m_ImageHeader = nn::xcd::IrCommonData();
    m_ImageHeader.irProcessorType = nn::xcd::IrProcessorType::Ready;
    //XcdDeviceBlock block;
    //RequestChangeMode(nn::xcd::IrProcessorType::Ready, block);
} //ReadyModeTestTask::DoInitialize()

//============================================================
void ReadyModeTestTask::DoFinalizeCore()
{
    //XcdDeviceBlock block;
    //RequestChangeMode(nn::xcd::IrProcessorType::Ready, block);
} //ReadyModeTestTask::DoFinalize()

//============================================================
void ReadyModeTestTask::DoCalcCore(IplImage* pImage)
{
    NN_UNUSED(pImage);
} //ReadyModeTestTask::DoCalc()

//============================================================
void ReadyModeTestTask::DoDrawCore(IplImage* pImage)
{
    // Clear buffer
    cvSetZero(pImage);
} //ReadyModeTestTask::DoDraw()


//============================================================
