﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_TextWriter.h"
#include "test_CvUtil.h"

namespace test {

namespace {
    const CvSize DEFAULT_FONT_SIZE = cvSize(32, 32);
} //namespace

//============================================================
void TextWriter::Initialize(const CvSize& fontSize)
{
    s32 font_face[] = {CV_FONT_HERSHEY_SIMPLEX};
    double width = static_cast<double>(fontSize.width) / static_cast<double>(DEFAULT_FONT_SIZE.width);
    double height = static_cast<double>(fontSize.height) / static_cast<double>(DEFAULT_FONT_SIZE.height);
    cvInitFont(&m_Font, font_face[0], width, height);

    m_FontSize = fontSize;
    m_FontColor = CONST_COLOR_WHITE;
    m_IsInitialized = true;
} //TextWriter::Initialize()

//============================================================
void TextWriter::Finalize()
{
    if (m_IsInitialized)
    {
        m_IsInitialized = false;
    }
} //TextWriter::Finalize()

//============================================================
void TextWriter::PutText(IplImage* pImage, const s32 x, const s32 y, const char* fmt, ...)
{
    TEST_ASSERT(m_IsInitialized);

    va_list list;
    va_start(list, fmt);
    vsnprintf_s(m_Text, TEXT_MAX_LEN, TEXT_MAX_LEN - 1, fmt, list);
    va_end(list);
    PutTextCore(pImage, x, y, m_Text);
} //TextWriter::PutText()

//============================================================
void TextWriter::PutTextCore(IplImage* pImage, const s32 x, const s32 y, const char* text)
{
    TEST_ASSERT(m_IsInitialized);

    // cvPutText は右下の座標を指定する形式なので変換する
    CvPoint point = cvPoint(x, y + m_FontSize.height);
    cvPutText(pImage, text, point, &m_Font, m_FontColor);
} //TextWriter::PutTextCore()

//============================================================

} //namespace test
