﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include "test_TaskBase.h"

namespace test {

//============================================================
TaskBase::TaskBase()
: m_IsInitialized(false)
, m_FrameCount(0)
, m_pFramework(NULL)
{
    std::memset(m_Name, 0, TASK_NAME_MAX_LEN + 1);
} //TaskBase::TaskBase()

//============================================================
TaskBase::TaskBase(const char* name, uptr arg)
: m_IsInitialized(false)
, m_FrameCount(0)
, m_pFramework(NULL)
{
    NN_UNUSED(arg);

    std::memset(m_Name, 0, TASK_NAME_MAX_LEN + 1);
    s32 len = 0;
    for (len = 0; len < TASK_NAME_MAX_LEN; len++)
    {
        if (name[len] == 0)
        {
            break;
        }
    }
    std::memcpy(m_Name, name, len);
    m_Name[TASK_NAME_MAX_LEN] = 0;
} //TaskBase::TaskBase()

//============================================================
TaskBase::~TaskBase()
{} //TaskBase::~TaskBase()

//============================================================
void TaskBase::Initialize(FrameworkBase *pFramework)
{
    TEST_ASSERT(!m_IsInitialized);
    m_pFramework = pFramework;   // DoIntialize の中で使えるように DoInitialize よりも前に登録する
    DoInitialize();
    m_FrameCount = 0;
    m_IsInitialized = true;
    TEST_PRINTF("test : Task (name=%s) is initialized\n", m_Name);
} //TaskBase::Initialize()

//============================================================
void TaskBase::Finalize()
{
    TEST_ASSERT(m_IsInitialized);
    DoFinalize();
    m_IsInitialized = false;
    TEST_PRINTF("test : Task (name=%s) is finalized\n", m_Name);
} //TaskBase::Finalize()

//============================================================
void TaskBase::Calc()
{
    DoCalc();
} //TaskBase::Calc()

//============================================================
void TaskBase::Draw()
{
    DoDraw();
    m_FrameCount++;
} //TaskBase::Draw()

//============================================================

} //namespace test
