﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "test_Common.h"
#include "test_TaskBase.h"
#include "test_TaskFactory.h"
#include "test_TextWriter.h"

#pragma warning(push)
#pragma warning(disable: 4668)
#include <opencv2/opencv.hpp>
#pragma warning(pop)

namespace test {

//============================================================
class ConsoleMenu : public TaskBase
{
public:
    struct CreateConfig
    {
        test::TaskFactoryContainer* pTaskFactoryTable;
        s32 taskNum;
        s32 firstIndex;

        CreateConfig()
        : pTaskFactoryTable(NULL)
        , taskNum(0)
        , firstIndex(0)
        {}
    };

public:
    ConsoleMenu(const char* name, uptr arg)
    : TaskBase(name, NULL)
    , m_CreateConfig()
    , m_Cursor(0)
    , m_pCurrentTask(NULL)
    , m_TextWriter()
    , m_pWindowImage(NULL)
    {
        CreateConfig* pCreateConfig = reinterpret_cast<CreateConfig*>(arg);
        TEST_ASSERT(pCreateConfig != NULL);
        m_CreateConfig = *pCreateConfig;
    }

    virtual ~ConsoleMenu()
    {}

private:
    ConsoleMenu();
    ConsoleMenu(const ConsoleMenu& src);
    ConsoleMenu& operator=(const ConsoleMenu& rhs);
    void DoChangeMode(int mode);

public:
    virtual void DoInitialize();
    virtual void DoFinalize();
    virtual void DoCalc();
    virtual void DoDraw();

private:
    CreateConfig m_CreateConfig;
    s32 m_Cursor;
    TaskBase* m_pCurrentTask;
    TextWriter m_TextWriter;
    IplImage* m_pWindowImage;
}; //class ConsoleMenu

//============================================================

} //namespace test

