﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "test_Common.h"
#include "test_FrameworkBase.h"

namespace test {

//============================================================
/**
 * Win32 コンソールフレームワークです。
 */
class ConsoleFrameworkOpenCv : public FrameworkBase
{
public:
    ConsoleFrameworkOpenCv()
    : m_IsInitialized(false)
    , m_FrameCount(0)
    , m_Keycode(0)
    {}

    virtual ~ConsoleFrameworkOpenCv()
    {}

private:
    ConsoleFrameworkOpenCv(const ConsoleFrameworkOpenCv& rhs);
    ConsoleFrameworkOpenCv& operator=(const ConsoleFrameworkOpenCv& rhs);

protected: //実装が義務付けられている処理の実装
    virtual void DoInitialize();
    virtual void DoFinalize();
    virtual void DoMainLoop();

public:
    s32 GetKeycode() const
    {
        return m_Keycode;
    }

private:
    bool m_IsInitialized;
    s32 m_FrameCount;
    s32 m_Keycode;
}; //ConsoleFrameworkOpenCv

} //namespace test
