﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/xcd/xcd.h>

#include "testXcd_TeraMcuFixture.h"

namespace nnt { namespace xcd {

// ステート遷移テストの試行回数
const int StateTransitionTestCount = 5;

// SetMcuState のリトライ最大回数
const int SetMcuStateRetryCountMax = 5;

// コントローラの接続切れタイムアウト
const auto DeviceAttachTimeout = nn::TimeSpan::FromSeconds(5);

// モード遷移のタイムアウト
const auto ModeTransitionTimeout = nn::TimeSpan::FromSeconds(5);

// Standby -> NFCへ切り替える時間の最大値
// (MCU 上での実測値は 256ms 程度、コントローラでの実測値は300ms程度で、追加で適当なマージンを見ている)
const auto StandbyToNfcTransitionTimeMax = nn::TimeSpan::FromMilliSeconds(500);

// Standby -> IRへ切り替える時間の最大値
// (MCU 上での実測値は 146ms 程度、コントローラでの実測値は300ms程度で、追加で適当なマージンを見ている)
const auto StandbyToIrTransitionTimeMax = nn::TimeSpan::FromMilliSeconds(500);

// NFC -> Standbyへ切り替える時間の最大値
// (MCU 上での実測値は110ms 程度、コントローラで完了を検知できないため、適当なマージンを見ている)
const auto NfcToStandbyTransitionTimeMax = nn::TimeSpan::FromMilliSeconds(200);

// IR -> Standbyへ切り替える時間の最大値
// (MCU 上での実測値は30ms 程度、コントローラで完了を検知できないため、適当なマージンを見ている)
const auto IrToStandbyTransitionTimeMax = nn::TimeSpan::FromMilliSeconds(150);

// コマンド呼び出しの定常インターバル
const auto CommandInterval = nn::TimeSpan::FromMilliSeconds(15);

// NFC -> Standby 後の待ち時間
const auto NfcToStandbyInterval = nn::TimeSpan::FromMilliSeconds(120);

// IR -> Standby 後の待ち時間
const auto IrToStandbyInterval = nn::TimeSpan::FromMilliSeconds(40);

}}  // nnt::xcd

// ---------------- 以下、テスト用のクラス定義 ----------------

/**
 * @brief   HID コマンドによるステート遷移テスト用クラス
 */
class XcdTeraMcuStateTransitionImmediate :
    public XcdTeraMcuBase,
    public ::testing::WithParamInterface<int>
{
};

/**
 * @brief   ステート遷移テスト用クラス
 */
class XcdTeraMcuStateTransition :
    public XcdTeraMcuBase,
    public ::testing::WithParamInterface<int>
{
};
