﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/xcd/xcd_NfcTypes.h>

namespace nnt { namespace xcd {

// NFC デバイスの接続タイムアウト
const auto DeviceAttachTimeout = nn::TimeSpan::FromSeconds(30);

// ステート遷移タイムアウト
const auto StateTransitionTimeout = nn::TimeSpan::FromSeconds(10);

// タグアクセスのリトライ回数
const int RetryCount = 3;

// リトライ時のウェイト
const auto RetryWait = nn::TimeSpan::FromMilliSeconds(500);

}}  // nnt::xcd
