﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <sstream>
#include <iomanip>

#include "TA_common.h"

namespace TestAgent {

using namespace std;

void ToUpper(char* str, int size)
{
    for(int i=0; i<size; ++i)
    {
        str[i] = std::toupper(str[i]);
    }
}

std::string ToStringSimpleTimeSpan(const nn::TimeSpan& timespan)
{
    nn::TimeSpan ts = timespan;
    ostringstream oss;
    bool pre = false;

    // 無限とみなす
    int64_t n = ts.GetDays();
    if(n > 30)
    {
        return "Infinity";
    }
    else if(n > 0)
    {
        oss << n << " day ";
        ts -= nn::TimeSpan::FromDays(n);
        pre = true;
    }

    n = ts.GetHours();
    if(n > 0 && !pre)
    {
        oss << n << " hour ";
        ts -= nn::TimeSpan::FromHours(n);
        pre = true;
    }

    n = ts.GetMinutes();
    if(n > 0 && !pre)
    {
        oss << n << " min ";
        ts -= nn::TimeSpan::FromMinutes(n);
        pre = true;
    }

    n = ts.GetSeconds();
    if(n > 0 && !pre)
    {
        oss << n << " sec ";
        ts -= nn::TimeSpan::FromSeconds(n);
        pre = true;
    }

    n = ts.GetMilliSeconds();
    if(n > 0 && !pre)
    {
        oss << n << " ms ";
        ts -= nn::TimeSpan::FromSeconds(n);
        pre = true;
    }

    if( !pre )
    {
        oss << "-";
    }

    return oss.str();
}
}
