﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include <memory>
#include <string>
#include <algorithm>
#include <winsock2.h>
#include <ws2tcpip.h>
#include <iphlpapi.h>
#include <windows.h>

#include <nn/nn_Assert.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/util/util_StringUtil.h>
#include <nn/util/util_FormatString.h>


#if defined(_WIN64)
typedef ULONGLONG SOCK;
#else
typedef ULONG SOCK;
#endif  // _WIN64

#if defined( NN_BUILD_TARGET_PLATFORM_OS_WIN )
#pragma execution_character_set("utf-8")
#endif

const UINT32 TcpBufferPoolCnt           = 20;
const size_t TcpBufferSize              = 1 * 1024 * 1024;
const size_t TcpRecvSize                = 2048;
const UINT32 TcpServerConnectMax        = 5;
const size_t TcpAcceptStackSize         = 4 * 1024 * 4;

struct TcpPoolMngDetail
{
    size_t bufferSize;
    size_t dataSize;
    char* pData;
};

struct TcpPoolMng
{
    UINT32 maxCount;
    UINT32 writeIdx;
    UINT32 readIdx;
    TcpPoolMngDetail info[TcpBufferPoolCnt];
    size_t bufferSize;
    size_t packetSize;
};

struct TcpDatail
{
    HANDLE hServerThread;
    HANDLE hClientThread;
    SOCK acceptSock;
    int port;
    struct sockaddr_in acceptAddr;
    size_t sendSize;
    DWORD sendInterval;
    size_t recvSize;
    HANDLE hStartEvent;
    void* pThis;    // pThisはCTcpClassクラス用ポインタで使用する。
    char ipAddress[INET_ADDRSTRLEN];
    bool isSetAccept;
    bool isStopThread;
};

struct TcpInfo
{
    SOCK srvSock;
    int port;
    struct sockaddr_in srvAddr;
    TcpDatail clientInfo[TcpServerConnectMax];
};

bool TcpSjisToUtf8(char strSjis[], int len) NN_NOEXCEPT;

bool TcpLogInitialize(size_t logSize) NN_NOEXCEPT;
void TcpTraceLogFileOpen(LPCSTR lpPath) NN_NOEXCEPT;
void TcpTraceLog(LPCSTR lpFormat, ...) NN_NOEXCEPT;
void TcpTraceLogFileClose() NN_NOEXCEPT;
void TcpLogFinalize() NN_NOEXCEPT;

class CTcpAutoLock
{
    NN_DISALLOW_COPY( CTcpAutoLock );
    NN_DISALLOW_MOVE( CTcpAutoLock );

public:
    NN_IMPLICIT CTcpAutoLock(HANDLE hMutex) NN_NOEXCEPT;
    virtual ~CTcpAutoLock() NN_NOEXCEPT;

    static bool Initialize(HANDLE& hMutex) NN_NOEXCEPT;
    static void Finalize(HANDLE& hMutex) NN_NOEXCEPT;

protected:
    HANDLE m_hMutex;
};

class CTcpClass
{
    NN_DISALLOW_COPY( CTcpClass );
    NN_DISALLOW_MOVE( CTcpClass );

public:
    CTcpClass() NN_NOEXCEPT;
    ~CTcpClass() NN_NOEXCEPT;

    DWORD SetupTcpServer(char* pIpAddress, USHORT port,
                size_t sendSize, DWORD sendInterval) NN_NOEXCEPT;
    void TearDownTcpServer() NN_NOEXCEPT;

    DWORD SetupTcpClient(char* pIpAddress, USHORT port,
                size_t sendSize, DWORD sendInterval) NN_NOEXCEPT;
    void TearDownTcpClient() NN_NOEXCEPT;

    DWORD GetCalcElapsedTick(DWORD dwStartTick) NN_NOEXCEPT;
    void LogOutIpAddress(USHORT port) NN_NOEXCEPT;
    void SetWindowsSize(int winSize) NN_NOEXCEPT;
    void SetLogoutTime(DWORD dwSetLogTime) NN_NOEXCEPT;

    static double GetByteCalc(size_t size) NN_NOEXCEPT;
    static std::string GetUnitByteCalc(size_t size, int32_t* pOutType = nullptr) NN_NOEXCEPT;

protected:
    bool SetPoolMngSetting(TcpPoolMng* pPoolMng, const size_t packetSize) NN_NOEXCEPT;
    TcpPoolMngDetail* GetNextWritePool(TcpPoolMng* pPoolMng) NN_NOEXCEPT;

    void CreateServerThread() NN_NOEXCEPT;
    void CreateClientThread() NN_NOEXCEPT;
    void ReleaseServerThread() NN_NOEXCEPT;
    void ReleaseClientThread() NN_NOEXCEPT;
    static void TcpServerThread(LPVOID) NN_NOEXCEPT;
    static void TcpClientThread(LPVOID) NN_NOEXCEPT;

    void TcpStop(TcpDatail*) NN_NOEXCEPT;

protected:
    HANDLE m_hServerAccept[TcpServerConnectMax];

    WSADATA m_wsaData;
    char* m_pRecvBuffer;
    TcpInfo m_tcpInfo;
    TcpPoolMng m_recvPoolMng;
    CRITICAL_SECTION m_crtPool;
    CRITICAL_SECTION m_crtTcp;
    bool m_isStart;
    DWORD m_logoutTime;
    int m_winSize;

    TCHAR m_strUnitByte[10];
};

