﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>

namespace nn { namespace wlan {

enum LogLevel {
    LogLevel_Fatal = 1,
    LogLevel_Error,
    LogLevel_Info,
    LogLevel_Debug,
};

extern int WlanLogLevel;

}}

#define WLAN_LOG_COMMAND(level, tag, fmt, ...)                             \
        do                                                                 \
        {                                                                  \
            if( nn::wlan::WlanLogLevel >= level )                          \
            {                                                              \
                NN_SDK_LOG("[WLAN][%s]" fmt, tag, ##__VA_ARGS__);       \
            }                                                              \
        } while(0)

#define WLAN_LOG_FATAL(fmt, ...)  WLAN_LOG_COMMAND(nn::wlan::LogLevel_Fatal, "FATAL", fmt, ##__VA_ARGS__)
#define WLAN_LOG_ERROR(fmt, ...)  WLAN_LOG_COMMAND(nn::wlan::LogLevel_Error, "ERROR", fmt,  ##__VA_ARGS__)
#define WLAN_LOG_INFO(fmt, ...)  WLAN_LOG_COMMAND(nn::wlan::LogLevel_Info, "INFO", fmt,  ##__VA_ARGS__)
#define WLAN_LOG_DEBUG(fmt, ...) WLAN_LOG_COMMAND(nn::wlan::LogLevel_Debug, "DEBUG", fmt,  ##__VA_ARGS__)

