﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testUtil_BenchmarkQuaternionApiWrapper.general.h"

namespace nn {
namespace util {
namespace general {

void QuaternionFromMatrixWrapper(Vector4fType* pOutValue, const MatrixRowMajor4x3fType& matrix)
{
    return QuaternionFromMatrix(pOutValue, matrix);
}
void QuaternionFromMatrixWrapper(Vector4fType* pOutValue, const MatrixColumnMajor4x3fType& matrix)
{
    return QuaternionFromMatrix(pOutValue, matrix);
}
void QuaternionIdentityWrapper(Vector4fType* pOutValue)
{
    return QuaternionIdentity(pOutValue);
}
void QuaternionAddWrapper(Vector4fType* pOutValue, const Vector4fType& quaternion1, const Vector4fType& quaternion2)
{
    return QuaternionAdd(pOutValue, quaternion1, quaternion2);
}
void QuaternionSubtractWrapper(Vector4fType* pOutValue, const Vector4fType& quaternion1, const Vector4fType& quaternion2)
{
    return QuaternionSubtract(pOutValue, quaternion1, quaternion2);
}
void QuaternionMultiplyWrapper(Vector4fType* pOutValue, const Vector4fType& quaternion, float factor)
{
    return QuaternionMultiply(pOutValue, quaternion, factor);
}
void QuaternionMultiplyWrapper(Vector4fType* pOutValue, const Vector4fType& quaternion1, const Vector4fType& quaternion2)
{
    return QuaternionMultiply(pOutValue, quaternion1, quaternion2);
}
void QuaternionDivideWrapper(Vector4fType* pOutValue, const Vector4fType& quaternion1, const Vector4fType& quaternion2)
{
    return QuaternionDivide(pOutValue, quaternion1, quaternion2);
}
float QuaternionDotWrapper(const Vector4fType& quaternion1, const Vector4fType& quaternion2)
{
    return QuaternionDot(quaternion1, quaternion2);
}
void QuaternionInverseWrapper(Vector4fType* pOutValue, const Vector4fType& quaternion)
{
    return QuaternionInverse(pOutValue, quaternion);
}
float QuaternionNormalizeWrapper(Vector4fType* pOutValue, const Vector4fType& quaternion)
{
    return QuaternionNormalize(pOutValue, quaternion);
}
void QuaternionExpWrapper(Vector4fType* pOutValue, const Vector4fType& quaternion)
{
    return QuaternionExp(pOutValue, quaternion);
}
void QuaternionLogNWrapper(Vector4fType* pOutValue, const Vector4fType& quaternion)
{
    return QuaternionLogN(pOutValue, quaternion);
}
void QuaternionLerpWrapper(Vector4fType* pOutValue, const Vector4fType& from, const Vector4fType& to, float t)
{
    return QuaternionLerp(pOutValue, from, to, t);
}
void QuaternionSlerpWrapper(Vector4fType* pOutValue, const Vector4fType& from, const Vector4fType& to, float t)
{
    return QuaternionSlerp(pOutValue, from, to, t);
}
void QuaternionSquadWrapper(Vector4fType* pOutValue, const Vector4fType& p, const Vector4fType& a, const Vector4fType& b, const Vector4fType& q, float t)
{
    return QuaternionSquad(pOutValue, p, a, b, q, t);
}
void QuaternionMakeClosestWrapper(Vector4fType*  pOutValue, const Vector4fType& quaternion, const Vector4fType& quaternionTo)
{
    return QuaternionMakeClosest(pOutValue, quaternion, quaternionTo);
}
void QuaternionRotateAxisWrapper(Vector4fType* pOutValue, const Vector3fType& axis, float rotationRadian)
{
    return QuaternionRotateAxis(pOutValue, axis, rotationRadian);
}
void QuaternionMakeVectorRotationWrapper(Vector4fType* pOutValue, const Vector3fType& from, const Vector3fType& to)
{
    return QuaternionMakeVectorRotation(pOutValue, from, to);
}

}
}
}
