﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/util/detail/util_MatrixApi.neon.h>

namespace nn {
namespace util {
namespace neon {

void MatrixLoadWrapper(MatrixRowMajor3x2fType* pOutValue, const FloatRowMajor3x2& source);
void MatrixLoadWrapper(MatrixRowMajor3x2fType* pOutValue, const FloatColumnMajor3x2& source);
void MatrixLoadWrapper(MatrixColumnMajor3x2fType* pOutValue, const FloatRowMajor3x2& source);
void MatrixLoadWrapper(MatrixColumnMajor3x2fType* pOutValue, const FloatColumnMajor3x2& source);
void MatrixStoreWrapper(FloatRowMajor3x2* pOutValue, const MatrixRowMajor3x2fType& source);
void MatrixStoreWrapper(FloatRowMajor3x2* pOutValue, const MatrixColumnMajor3x2fType& source);
void MatrixStoreWrapper(FloatColumnMajor3x2* pOutValue, const MatrixRowMajor3x2fType& source);
void MatrixStoreWrapper(FloatColumnMajor3x2* pOutValue, const MatrixColumnMajor3x2fType& source);
void MatrixSetWrapper(MatrixRowMajor3x2fType* pOutValue, float m00, float m01, float m10, float m11, float m20, float m21);
void MatrixSetWrapper(MatrixColumnMajor3x2fType* pOutValue, float m00, float m01, float m10, float m11, float m20, float m21);
void MatrixSetRowWrapper(MatrixRowMajor3x2fType* pOutValue, int index, const Vector2fType& vector);
void MatrixSetRowWrapper(MatrixColumnMajor3x2fType* pOutValue, int index, const Vector2fType& vector);
void MatrixSetRowsWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector2fType& row0, const Vector2fType& row1, const Vector2fType& row2);
void MatrixSetRowsWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector2fType& row0, const Vector2fType& row1, const Vector2fType& row2);
void MatrixGetRowWrapper(Vector2fType* pOutValue, const MatrixRowMajor3x2fType& matrix, int index);
void MatrixGetRowWrapper(Vector2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix, int index);
void MatrixGetRowsWrapper(Vector2fType* pOutRow0, Vector2fType* pOutRow1, Vector2fType* pOutRow2, const MatrixRowMajor3x2fType& matrix);
void MatrixGetRowsWrapper(Vector2fType* pOutRow0, Vector2fType* pOutRow1, Vector2fType* pOutRow2, const MatrixColumnMajor3x2fType& matrix);
void MatrixSetColumnWrapper(MatrixRowMajor3x2fType* pOutValue, int index, const Vector3fType& vector);
void MatrixSetColumnWrapper(MatrixColumnMajor3x2fType* pOutValue, int index, const Vector3fType& vector);
void MatrixSetColumnsWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector3fType& column0, const Vector3fType& column1);
void MatrixSetColumnsWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector3fType& column0, const Vector3fType& column1);
void MatrixGetColumnWrapper(Vector3fType* pOutValue, const MatrixRowMajor3x2fType& matrix, int index);
void MatrixGetColumnWrapper(Vector3fType* pOutValue, const MatrixColumnMajor3x2fType& matrix, int index);
void MatrixGetColumnsWrapper(Vector3fType* pOutColumn0, Vector3fType* pOutColumn1, const MatrixRowMajor3x2fType& matrix);
void MatrixGetColumnsWrapper(Vector3fType* pOutColumn0, Vector3fType* pOutColumn1, const MatrixColumnMajor3x2fType& matrix);
void MatrixSetAxisXWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector2fType& vector);
void MatrixSetAxisXWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector2fType& vector);
void MatrixSetAxisYWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector2fType& vector);
void MatrixSetAxisYWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector2fType& vector);
void MatrixSetAxisZWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector2fType& vector);
void MatrixSetAxisZWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector2fType& vector);
void MatrixSetAxesWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector2fType& axisX, const Vector2fType& axisY, const Vector2fType& axisZ);
void MatrixSetAxesWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector2fType& axisX, const Vector2fType& axisY, const Vector2fType& axisZ);
void MatrixGetAxisXWrapper(Vector2fType* pOutValue, const MatrixRowMajor3x2fType& matrix);
void MatrixGetAxisXWrapper(Vector2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix);
void MatrixGetAxisYWrapper(Vector2fType* pOutValue, const MatrixRowMajor3x2fType& matrix);
void MatrixGetAxisYWrapper(Vector2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix);
void MatrixGetAxisZWrapper(Vector2fType* pOutValue, const MatrixRowMajor3x2fType& matrix);
void MatrixGetAxisZWrapper(Vector2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix);
void MatrixGetAxesWrapper(Vector2fType* pOutAxisX, Vector2fType* pOutAxisY, Vector2fType* pOutAxisZ, const MatrixRowMajor3x2fType& matrix);
void MatrixGetAxesWrapper(Vector2fType* pOutAxisX, Vector2fType* pOutAxisY, Vector2fType* pOutAxisZ, const MatrixColumnMajor3x2fType& matrix);
void MatrixZeroWrapper(MatrixRowMajor3x2fType* pOutValue);
void MatrixZeroWrapper(MatrixColumnMajor3x2fType* pOutValue);
void MatrixIdentityWrapper(MatrixRowMajor3x2fType* pOutValue);
void MatrixIdentityWrapper(MatrixColumnMajor3x2fType* pOutValue);
void MatrixAddWrapper(MatrixRowMajor3x2fType* pOutValue, const MatrixRowMajor3x2fType& matrix1, const MatrixRowMajor3x2fType& matrix2);
void MatrixAddWrapper(MatrixColumnMajor3x2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix1, const MatrixColumnMajor3x2fType& matrix2);
void MatrixSubtractWrapper(MatrixRowMajor3x2fType* pOutValue, const MatrixRowMajor3x2fType& matrix1, const MatrixRowMajor3x2fType& matrix2);
void MatrixSubtractWrapper(MatrixColumnMajor3x2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix1, const MatrixColumnMajor3x2fType& matrix2);
void MatrixMultiplyWrapper(MatrixRowMajor3x2fType* pOutValue, const MatrixRowMajor3x2fType& matrix, float factor);
void MatrixMultiplyWrapper(MatrixColumnMajor3x2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix, float factor);
void MatrixMultiplyWrapper(MatrixRowMajor3x2fType* pOutValue, const MatrixRowMajor3x2fType& matrix1, const MatrixRowMajor3x2fType& matrix2);
void MatrixMultiplyWrapper(MatrixColumnMajor3x2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix1, const MatrixColumnMajor3x2fType& matrix2);
void MatrixMultiplyAddWrapper(MatrixRowMajor3x2fType* pOutValue, float t, const MatrixRowMajor3x2fType& matrix1, const MatrixRowMajor3x2fType& matrix2);
void MatrixMultiplyAddWrapper(MatrixColumnMajor3x2fType* pOutValue, float t, const MatrixColumnMajor3x2fType& matrix1, const MatrixColumnMajor3x2fType& matrix2);
void MatrixDivideWrapper(MatrixRowMajor3x2fType* pOutValue, const MatrixRowMajor3x2fType& matrix, float factor);
void MatrixDivideWrapper(MatrixColumnMajor3x2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix, float factor);
bool MatrixInverseWrapper(MatrixRowMajor3x2fType* pOutValue, const MatrixRowMajor3x2fType& matrix);
bool MatrixInverseWrapper(MatrixColumnMajor3x2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix);
void MatrixTransposeWrapper(MatrixRowMajor3x2fType* pOutValue, const MatrixRowMajor3x2fType& matrix);
void MatrixTransposeWrapper(MatrixColumnMajor3x2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix);
bool MatrixInverseTransposeWrapper(MatrixRowMajor3x2fType* pOutValue, const MatrixRowMajor3x2fType& matrix);
bool MatrixInverseTransposeWrapper(MatrixColumnMajor3x2fType* pOutValue, const MatrixColumnMajor3x2fType& matrix);
void MatrixSetTranslateWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector2fType& translate);
void MatrixSetTranslateWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector2fType& translate);
void MatrixSetScaleWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector2fType& scale);
void MatrixSetScaleWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector2fType& scale);
void MatrixSetRotateWrapper(MatrixRowMajor3x2fType* pOutValue, float rotationRadian);
void MatrixSetRotateWrapper(MatrixColumnMajor3x2fType* pOutValue, float rotationRadian);
void MatrixSetScaleRotateWrapper(MatrixRowMajor3x2fType* pOutValue, const Vector2fType& scale, float rotationRadian);
void MatrixSetScaleRotateWrapper(MatrixColumnMajor3x2fType* pOutValue, const Vector2fType& scale, float rotationRadian);
void MatrixFromQuaternionWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector4fType& quaternion);
void MatrixFromQuaternionWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector4fType& quaternion);
void MatrixLoadWrapper(MatrixRowMajor4x3fType* pOutValue, const FloatRowMajor4x3& source);
void MatrixLoadWrapper(MatrixRowMajor4x3fType* pOutValue, const FloatColumnMajor4x3& source);
void MatrixLoadWrapper(MatrixColumnMajor4x3fType* pOutValue, const FloatRowMajor4x3& source);
void MatrixLoadWrapper(MatrixColumnMajor4x3fType* pOutValue, const FloatColumnMajor4x3& source);
void MatrixStoreWrapper(FloatRowMajor4x3* pOutValue, const MatrixRowMajor4x3fType& source);
void MatrixStoreWrapper(FloatRowMajor4x3* pOutValue, const MatrixColumnMajor4x3fType& source);
void MatrixStoreWrapper(FloatColumnMajor4x3* pOutValue, const MatrixRowMajor4x3fType& source);
void MatrixStoreWrapper(FloatColumnMajor4x3* pOutValue, const MatrixColumnMajor4x3fType& source);
void MatrixConvertWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x3fType& source);
void MatrixConvertWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x3fType& source);
void MatrixSetWrapper(MatrixRowMajor4x3fType* pOutValue, float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22, float m30, float m31, float m32);
void MatrixSetWrapper(MatrixColumnMajor4x3fType* pOutValue, float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22, float m30, float m31, float m32);
void MatrixSetRowWrapper(MatrixRowMajor4x3fType* pOutValue, int index, const Vector3fType& vector);
void MatrixSetRowWrapper(MatrixColumnMajor4x3fType* pOutValue, int index, const Vector3fType& vector);
void MatrixSetRowsWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& row0, const Vector3fType& row1, const Vector3fType& row2, const Vector3fType& row3);
void MatrixSetRowsWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& row0, const Vector3fType& row1, const Vector3fType& row2, const Vector3fType& row3);
void MatrixGetRowWrapper(Vector3fType* pOutValue, const MatrixRowMajor4x3fType& matrix, int index);
void MatrixGetRowWrapper(Vector3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix, int index);
void MatrixGetRowsWrapper(Vector3fType* pOutRow0, Vector3fType* pOutRow1, Vector3fType* pOutRow2, Vector3fType* pOutRow3, const MatrixRowMajor4x3fType& matrix);
void MatrixGetRowsWrapper(Vector3fType* pOutRow0, Vector3fType* pOutRow1, Vector3fType* pOutRow2, Vector3fType* pOutRow3, const MatrixColumnMajor4x3fType& matrix);
void MatrixSetColumnWrapper(MatrixRowMajor4x3fType* pOutValue, int index, const Vector4fType& vector);
void MatrixSetColumnWrapper(MatrixColumnMajor4x3fType* pOutValue, int index, const Vector4fType& vector);
void MatrixSetColumnsWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector4fType& column0, const Vector4fType& column1, const Vector4fType& column2);
void MatrixSetColumnsWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector4fType& column0, const Vector4fType& column1, const Vector4fType& column2);
void MatrixGetColumnWrapper(Vector4fType* pOutValue, const MatrixRowMajor4x3fType& matrix, int index);
void MatrixGetColumnWrapper(Vector4fType* pOutValue, const MatrixColumnMajor4x3fType& matrix, int index);
void MatrixGetColumnsWrapper(Vector4fType* pOutColumn0, Vector4fType* pOutColumn1, Vector4fType* pOutColumn2, const MatrixRowMajor4x3fType& matrix);
void MatrixGetColumnsWrapper(Vector4fType* pOutColumn0, Vector4fType* pOutColumn1, Vector4fType* pOutColumn2, const MatrixColumnMajor4x3fType& matrix);
void MatrixSetAxisXWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& vector);
void MatrixSetAxisXWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& vector);
void MatrixSetAxisYWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& vector);
void MatrixSetAxisYWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& vector);
void MatrixSetAxisZWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& vector);
void MatrixSetAxisZWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& vector);
void MatrixSetAxisWWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& vector);
void MatrixSetAxisWWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& vector);
void MatrixSetAxesWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& axisX, const Vector3fType& axisY, const Vector3fType& axisZ, const Vector3fType& axisW);
void MatrixSetAxesWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& axisX, const Vector3fType& axisY, const Vector3fType& axisZ, const Vector3fType& axisW);
void MatrixGetAxisXWrapper(Vector3fType* pOutValue, const MatrixRowMajor4x3fType& matrix);
void MatrixGetAxisXWrapper(Vector3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix);
void MatrixGetAxisYWrapper(Vector3fType* pOutValue, const MatrixRowMajor4x3fType& matrix);
void MatrixGetAxisYWrapper(Vector3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix);
void MatrixGetAxisZWrapper(Vector3fType* pOutValue, const MatrixRowMajor4x3fType& matrix);
void MatrixGetAxisZWrapper(Vector3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix);
void MatrixGetAxisWWrapper(Vector3fType* pOutValue, const MatrixRowMajor4x3fType& matrix);
void MatrixGetAxisWWrapper(Vector3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix);
void MatrixGetAxesWrapper(Vector3fType* pOutAxisX, Vector3fType* pOutAxisY, Vector3fType* pOutAxisZ, Vector3fType* pOutAxisW, const MatrixRowMajor4x3fType& matrix);
void MatrixGetAxesWrapper(Vector3fType* pOutAxisX, Vector3fType* pOutAxisY, Vector3fType* pOutAxisZ, Vector3fType* pOutAxisW, const MatrixColumnMajor4x3fType& matrix);
void MatrixZeroWrapper(MatrixRowMajor4x3fType* pOutValue);
void MatrixZeroWrapper(MatrixColumnMajor4x3fType* pOutValue);
void MatrixIdentityWrapper(MatrixRowMajor4x3fType* pOutValue);
void MatrixIdentityWrapper(MatrixColumnMajor4x3fType* pOutValue);
void MatrixAddWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x3fType& matrix1, const MatrixRowMajor4x3fType& matrix2);
void MatrixAddWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix1, const MatrixColumnMajor4x3fType& matrix2);
void MatrixSubtractWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x3fType& matrix1, const MatrixRowMajor4x3fType& matrix2);
void MatrixSubtractWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix1, const MatrixColumnMajor4x3fType& matrix2);
void MatrixMultiplyWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x3fType& matrix, float factor);
void MatrixMultiplyWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix, float factor);
void MatrixMultiplyWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x3fType& matrix1, const MatrixRowMajor4x3fType& matrix2);
void MatrixMultiplyWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix1, const MatrixColumnMajor4x3fType& matrix2);
void MatrixMultiplyWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x3fType& matrix1, const MatrixRowMajor4x4fType& matrix2);
void MatrixMultiplyWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x3fType& matrix1, const MatrixColumnMajor4x4fType& matrix2);
void MatrixMultiplyAddWrapper(MatrixRowMajor4x3fType* pOutValue, float t, const MatrixRowMajor4x3fType& matrix1, const MatrixRowMajor4x3fType& matrix2);
void MatrixMultiplyAddWrapper(MatrixColumnMajor4x3fType* pOutValue, float t, const MatrixColumnMajor4x3fType& matrix1, const MatrixColumnMajor4x3fType& matrix2);
void MatrixDivideWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x3fType& matrix, float factor);
void MatrixDivideWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix, float factor);
bool MatrixInverseWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x3fType& matrix);
bool MatrixInverseWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix);
void MatrixTransposeWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x3fType& matrix);
void MatrixTransposeWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix);
bool MatrixInverseTransposeWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x3fType& matrix);
bool MatrixInverseTransposeWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x3fType& matrix);
void MatrixLookAtRightHandedWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& cameraPosition, const Vector3fType& target, const Vector3fType& up);
void MatrixLookAtRightHandedWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& cameraPosition, const Vector3fType& target, const Vector3fType& up);
void MatrixLookAtRightHandedWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& cameraPosition, const Vector3fType& target, float twistRadian);
void MatrixLookAtRightHandedWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& cameraPosition, const Vector3fType& target, float twistRadian);
void MatrixCameraRotateZxyWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& cameraPosition, const Vector3fType& rotationRadian);
void MatrixCameraRotateZxyWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& cameraPosition, const Vector3fType& rotationRadian);
void MatrixSetTranslateWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& translate);
void MatrixSetTranslateWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& translate);
void MatrixSetScaleWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& scale);
void MatrixSetScaleWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& scale);
void MatrixSetRotateWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector4fType& rotationQuaternion);
void MatrixSetRotateWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector4fType& rotationQuaternion);
void MatrixSetRotateXyzWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& rotationRadian);
void MatrixSetRotateXyzWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& rotationRadian);
void MatrixSetScaleRotateWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& scale, const Vector4fType& rotationQuaternion);
void MatrixSetScaleRotateWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& scale, const Vector4fType& rotationQuaternion);
void MatrixSetScaleRotateXyzWrapper(MatrixRowMajor4x3fType* pOutValue, const Vector3fType& scale, const Vector3fType& rotationRadian);
void MatrixSetScaleRotateXyzWrapper(MatrixColumnMajor4x3fType* pOutValue, const Vector3fType& scale, const Vector3fType& rotationRadian);
void MatrixTextureProjectionPerspectiveOffCenterRightHandedWrapper(MatrixRowMajor4x3fType* pOutValue, float left, float right, float bottom, float top, float nearZ);
void MatrixTextureProjectionPerspectiveOffCenterRightHandedWrapper(MatrixColumnMajor4x3fType* pOutValue, float left, float right, float bottom, float top, float nearZ);
void MatrixTextureProjectionPerspectiveFieldOfViewRightHandedWrapper(MatrixRowMajor4x3fType* pOutValue, float fovyRadian, float aspect);
void MatrixTextureProjectionPerspectiveFieldOfViewRightHandedWrapper(MatrixColumnMajor4x3fType* pOutValue, float fovyRadian, float aspect);
void MatrixTextureProjectionOrthographicOffCenterRightHandedWrapper(MatrixRowMajor4x3fType* pOutValue, float left, float right, float bottom, float top);
void MatrixTextureProjectionOrthographicOffCenterRightHandedWrapper(MatrixColumnMajor4x3fType* pOutValue, float left, float right, float bottom, float top);
void MatrixLoadWrapper(MatrixRowMajor4x4fType* pOutValue, const FloatRowMajor4x4& source);
void MatrixLoadWrapper(MatrixRowMajor4x4fType* pOutValue, const FloatColumnMajor4x4& source);
void MatrixLoadWrapper(MatrixColumnMajor4x4fType* pOutValue, const FloatRowMajor4x4& source);
void MatrixLoadWrapper(MatrixColumnMajor4x4fType* pOutValue, const FloatColumnMajor4x4& source);
void MatrixStoreWrapper(FloatRowMajor4x4* pOutValue, const MatrixRowMajor4x4fType& source);
void MatrixStoreWrapper(FloatRowMajor4x4* pOutValue, const MatrixColumnMajor4x4fType& source);
void MatrixStoreWrapper(FloatColumnMajor4x4* pOutValue, const MatrixRowMajor4x4fType& source);
void MatrixStoreWrapper(FloatColumnMajor4x4* pOutValue, const MatrixColumnMajor4x4fType& source);
void MatrixConvertWrapper(MatrixRowMajor4x3fType* pOutValue, const MatrixRowMajor4x4fType& source);
void MatrixConvertWrapper(MatrixColumnMajor4x3fType* pOutValue, const MatrixColumnMajor4x4fType& source);
void MatrixSetWrapper(MatrixRowMajor4x4fType* pOutValue, float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33);
void MatrixSetWrapper(MatrixColumnMajor4x4fType* pOutValue, float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33);
void MatrixSetRowWrapper(MatrixRowMajor4x4fType* pOutValue, int index, const Vector4fType& vector);
void MatrixSetRowWrapper(MatrixColumnMajor4x4fType* pOutValue, int index, const Vector4fType& vector);
void MatrixSetRowsWrapper(MatrixRowMajor4x4fType* pOutValue, const Vector4fType& row0, const Vector4fType& row1, const Vector4fType& row2, const Vector4fType& row3);
void MatrixSetRowsWrapper(MatrixColumnMajor4x4fType* pOutValue, const Vector4fType& row0, const Vector4fType& row1, const Vector4fType& row2, const Vector4fType& row3);
void MatrixGetRowWrapper(Vector4fType* pOutValue, const MatrixRowMajor4x4fType& matrix, int index);
void MatrixGetRowWrapper(Vector4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix, int index);
void MatrixGetRowsWrapper(Vector4fType* pOutRow0, Vector4fType* pOutRow1, Vector4fType* pOutRow2, Vector4fType* pOutRow3, const MatrixRowMajor4x4fType& matrix);
void MatrixGetRowsWrapper(Vector4fType* pOutRow0, Vector4fType* pOutRow1, Vector4fType* pOutRow2, Vector4fType* pOutRow3, const MatrixColumnMajor4x4fType& matrix);
void MatrixSetColumnWrapper(MatrixRowMajor4x4fType* pOutValue, int index, const Vector4fType& vector);
void MatrixSetColumnWrapper(MatrixColumnMajor4x4fType* pOutValue, int index, const Vector4fType& vector);
void MatrixSetColumnsWrapper(MatrixRowMajor4x4fType* pOutValue, const Vector4fType& column0, const Vector4fType& column1, const Vector4fType& column2, const Vector4fType& column3);
void MatrixSetColumnsWrapper(MatrixColumnMajor4x4fType* pOutValue, const Vector4fType& column0, const Vector4fType& column1, const Vector4fType& column2, const Vector4fType& column3);
void MatrixGetColumnWrapper(Vector4fType* pOutValue, const MatrixRowMajor4x4fType& matrix, int index);
void MatrixGetColumnWrapper(Vector4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix, int index);
void MatrixGetColumnsWrapper(Vector4fType* pOutColumn0, Vector4fType* pOutColumn1, Vector4fType* pOutColumn2, Vector4fType* pOutColumn3, const MatrixRowMajor4x4fType& matrix);
void MatrixGetColumnsWrapper(Vector4fType* pOutColumn0, Vector4fType* pOutColumn1, Vector4fType* pOutColumn2, Vector4fType* pOutColumn3, const MatrixColumnMajor4x4fType& matrix);
void MatrixSetAxisXWrapper(MatrixRowMajor4x4fType* pOutValue, const Vector4fType& vector);
void MatrixSetAxisXWrapper(MatrixColumnMajor4x4fType* pOutValue, const Vector4fType& vector);
void MatrixSetAxisYWrapper(MatrixRowMajor4x4fType* pOutValue, const Vector4fType& vector);
void MatrixSetAxisYWrapper(MatrixColumnMajor4x4fType* pOutValue, const Vector4fType& vector);
void MatrixSetAxisZWrapper(MatrixRowMajor4x4fType* pOutValue, const Vector4fType& vector);
void MatrixSetAxisZWrapper(MatrixColumnMajor4x4fType* pOutValue, const Vector4fType& vector);
void MatrixSetAxisWWrapper(MatrixRowMajor4x4fType* pOutValue, const Vector4fType& vector);
void MatrixSetAxisWWrapper(MatrixColumnMajor4x4fType* pOutValue, const Vector4fType& vector);
void MatrixSetAxesWrapper(MatrixRowMajor4x4fType* pOutValue, const Vector4fType& axisX, const Vector4fType& axisY, const Vector4fType& axisZ, const Vector4fType& axisW);
void MatrixSetAxesWrapper(MatrixColumnMajor4x4fType* pOutValue, const Vector4fType& axisX, const Vector4fType& axisY, const Vector4fType& axisZ, const Vector4fType& axisW);
void MatrixGetAxisXWrapper(Vector4fType* pOutValue, const MatrixRowMajor4x4fType& matrix);
void MatrixGetAxisXWrapper(Vector4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix);
void MatrixGetAxisYWrapper(Vector4fType* pOutValue, const MatrixRowMajor4x4fType& matrix);
void MatrixGetAxisYWrapper(Vector4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix);
void MatrixGetAxisZWrapper(Vector4fType* pOutValue, const MatrixRowMajor4x4fType& matrix);
void MatrixGetAxisZWrapper(Vector4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix);
void MatrixGetAxisWWrapper(Vector4fType* pOutValue, const MatrixRowMajor4x4fType& matrix);
void MatrixGetAxisWWrapper(Vector4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix);
void MatrixGetAxesWrapper(Vector4fType* pOutAxisX, Vector4fType* pOutAxisY, Vector4fType* pOutAxisZ, Vector4fType* pOutAxisW, const MatrixRowMajor4x4fType& matrix);
void MatrixGetAxesWrapper(Vector4fType* pOutAxisX, Vector4fType* pOutAxisY, Vector4fType* pOutAxisZ, Vector4fType* pOutAxisW, const MatrixColumnMajor4x4fType& matrix);
void MatrixZeroWrapper(MatrixRowMajor4x4fType* pOutValue);
void MatrixZeroWrapper(MatrixColumnMajor4x4fType* pOutValue);
void MatrixIdentityWrapper(MatrixRowMajor4x4fType* pOutValue);
void MatrixIdentityWrapper(MatrixColumnMajor4x4fType* pOutValue);
void MatrixAddWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x4fType& matrix1, const MatrixRowMajor4x4fType& matrix2);
void MatrixAddWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix1, const MatrixColumnMajor4x4fType& matrix2);
void MatrixSubtractWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x4fType& matrix1, const MatrixRowMajor4x4fType& matrix2);
void MatrixSubtractWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix1, const MatrixColumnMajor4x4fType& matrix2);
void MatrixMultiplyWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x4fType& matrix, float factor);
void MatrixMultiplyWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix, float factor);
void MatrixMultiplyWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x4fType& matrix1, const MatrixRowMajor4x3fType& matrix2);
void MatrixMultiplyWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix1, const MatrixColumnMajor4x3fType& matrix2);
void MatrixMultiplyWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x4fType& matrix1, const MatrixRowMajor4x4fType& matrix2);
void MatrixMultiplyWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix1, const MatrixColumnMajor4x4fType& matrix2);
void MatrixDivideWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x4fType& matrix, float factor);
void MatrixDivideWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix, float factor);
bool MatrixInverseWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x4fType& matrix);
bool MatrixInverseWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix);
void MatrixTransposeWrapper(MatrixRowMajor4x4fType* pOutValue, const MatrixRowMajor4x4fType& matrix);
void MatrixTransposeWrapper(MatrixColumnMajor4x4fType* pOutValue, const MatrixColumnMajor4x4fType& matrix);
void MatrixPerspectiveOffCenterRightHandedWrapper(MatrixRowMajor4x4fType* pOutValue, float left, float right, float bottom, float top, float nearZ, float farZ);
void MatrixPerspectiveOffCenterRightHandedWrapper(MatrixColumnMajor4x4fType* pOutValue, float left, float right, float bottom, float top, float nearZ, float farZ);
void MatrixPerspectiveFieldOfViewRightHandedWrapper(MatrixRowMajor4x4fType* pOutValue, float fovyRadian, float aspect, float nearZ, float farZ);
void MatrixPerspectiveFieldOfViewRightHandedWrapper(MatrixColumnMajor4x4fType* pOutValue, float fovyRadian, float aspect, float nearZ, float farZ);
void MatrixOrthographicOffCenterRightHandedWrapper(MatrixRowMajor4x4fType* pOutValue, float left, float right, float bottom, float top, float nearZ, float farZ);
void MatrixOrthographicOffCenterRightHandedWrapper(MatrixColumnMajor4x4fType* pOutValue, float left, float right, float bottom, float top, float nearZ, float farZ);

}
}
}
