﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "CheckBox.h"

namespace nnt {
namespace usb {

CheckBox::CheckBox(const char *caption, bool checked, OnCheckCallback onCheck)
    : m_Placer(*this, glv::Direction::E, glv::Place::CL, 0, 0, 10)
    , m_CheckBox(glv::Rect(40), false, glv::draw::x)
    , m_Caption(caption)
    , m_OnCheck(onCheck)
{
    m_Caption.size(30);

    m_Placer << m_CheckBox << m_Caption;
    fit();

    m_CheckBox.setValue(checked);
    m_CheckBox.attach(
        [](const glv::Notification& n)->void {
            n.receiver<CheckBox>()->OnCheck();
        },
        glv::Update::Value,
        this
    );
}

CheckBox::~CheckBox()
{
}

bool CheckBox::IsChecked()
{
    return m_CheckBox.getValue();
}

void CheckBox::OnCheck()
{
    if (m_OnCheck)
    {
        m_OnCheck(IsChecked());
    }
}


} // ~usb
} // ~nnt
